﻿;Parašykite programą, kuri atspausdina įvestos simbolių eilutės ASCII kodus dešimtainiu pavidalu;
      ; Pvz.: įvedus abC1 turi atspausdinti 97 98 67 49
;****************************************************************************************************;

.model small
	
.stack 100h
	BufferDydis EQU 255
.data
	pranesimas1	DB "Iveskite simboliu eilute: ", 13, 10, "$"													;apsibreziam pranesimus ka noresim spausdinti
	pranesimas2 DB "Programa baige darba, nes neivedete duomenu. $"
	help        DB "Vardenis Pavardenis PS X.X ", 13, 10, "Programa paraso ivestos simboliu eilutes ASCII kodus desimtainiu pavidalu.", 13, 10, "$"		;helpo pranesimas
	BuffDydis   DB BufferDydis    								;buferis bus 257baitai, maksimaliai
	nuskaite    DB ?       										;tiek simboliu mes ivedem
	buferis     DB BufferDydis dup (?)    						;simboliai kuriuos mes ivedem bus talpinami cia
	rezultatas  DB "Ivestos simboliu eilutes ASCII kodas desimtainiu pavidalu yra: ", 13, 10, "$"							;rezultato isvedimas	
	enteris 	DB 13, 10, "$"									;perejimas i kita eilute
	space 		DB " $"
.code

Pradzia:
	MOV 	ax, @data 				;tas adresas kuris nurodo duomenu segmento pradzia
	MOV		ds, ax   				;i ds ikeliam ta reiksme kuri yra ax
;****************************************************************************************************;
	MOV		ch, 0			
	MOV		cl, [es:0080h]			;programos paleidimo parametrø simboliu skaicius raðomas ES 128-ame (80h) baite
	CMP		cx, 0					;jei paleidimo parametru nera,
	JE		Nera					;nereikia nieko tikrinti.
	MOV		bx, 0081h				;programos paleidimo parametrai rasomi segmente es pradedant 129 (arba 81h) baitu
Ieskok:
	CMP		[es:bx], '?/'			;atmintyje jaunesnysis baitas saugomas pirmiau,
									;todël pirmasis baitas irasomas i bl, o antrasis i bh.
									;taip '/?' virsta '?/'.
	JE		Yra						;jeigu radau '/?', vadinasi reikia spausdinti pranesima
	INC		bx						;neradau '/?' siuose baituose, paslenku rodykle ir tikrinu toliau esancius parametrus
	LOOP	Ieskok					;jei dar nepatikrinti visi parametrai, reikia tikrinti toliau

	JMP		Nera					;jei patikrinti visi parametrai ir nerastas '/?' reikia baigti programos darba

									;spausdinu i ekrana pagalbos pranesima
Yra:
	MOV		ah, 09h					;i ah irasau dosinio pertraukimo funkcijos numeri
	MOV		dx, offset help			;i dx iraðau nuoroda i spausdinamo teksto pradzia
	INT		21h						;iskvieciu dosine pertraukima - spausdinu pranesima	
	JMP 	Pabaiga

Nera:
;****************************************************************************************************;
Programa:	
;**********nuskaite eilute***************************************************************************;	

	MOV 	ah, 09h           		;i ekrana isveda pranesima kad ivestume simboliu eilute	
	MOV 	dx, offset pranesimas1
	INT 	21h

	MOV 	ah, 0Ah                	;nuskaitome visa simboliu eilute i bufferi
	MOV 	dx, offset BuffDydis
	INT 	21h
	
	MOV 	ah, 09h					;pereiname i kita eilute, enter
	MOV 	dx, offset enteris
	INT		21h
	
;*********isimete reiksmes ir parase atsakymo pradzios eilute****************************************;

	MOV 	cl, nuskaite			;i cl idedama kiek	simboliu nuskaite programa
									;cl - keik simbolio liko perziureti	
	CMP 	cl, 0					;jei cl lygus 0, reiskias nieko neivede, programa baigiama
	JNE 	Cia						;jei nelygu tesiam darba
	
	MOV 	ah, 09h           		;i ekrana isveda pranesima kad nieko neivedeme ir baigiam darba
	MOV 	dx, offset pranesimas2
	INT 	21h
	JMP 	Pabaiga					;soka i programos pabaigima
	
Cia:
	MOV 	ah, 09h					;isveda i ekrana pranesima kad isvedamas atsakymas	
	MOV 	dx, offset rezultatas	;isveda i ekrana pranesima kad isvedamas atsakymas	
	INT 	21h						;isveda i ekrana pranesima kad isvedamas atsakymas		
	
	PUSH	cx						;issisaugom cx steke, akd zinotume kiek nariu turim
	
	MOV 	bx, offset buferis 		;i bx imetam pirmo simbolio adresa	
	
;*******************pasiruosiu dalybai duomenis, sumetu i registrus**********************************;

Idejimas:
	MOV 	ah, 0					;i ah metam nuli nes mums reikia tik vieno baito
	MOV 	al,	byte ptr[ds:bx]		;i al imetam adresa kuris rodo pirma simboli
	
	MOV 	cx, 10					;i cx imetam 10, nes reikes rasti leikana tai modinu is 10 
	PUSH	"$$"					;imetu zenkla po kurio programa zinos kada baigiais skaicius
	
;*******************dalinu, liekana vis metu i steka*************************************************;

Dalyba:
	MOV 	dx, 0					;dx nusinulinu, nes ten imetines liekana
	DIV 	cx						;dalina ax is 10
	PUSH 	dx						;gauta liekana imetu i stecka
	CMP		ax, 0					;jei dar liko ka dalinti dalinam dar karta
	JA 		Dalyba					;jei daugiau uz nuli kartoja
	
	MOV 	ah, 02h					;isvedimas prasidejo
	
;****isvedineju skaicius isismtus is steko, pries tai juos paversdamas skaiciaus simboliu (add 48)***;

Isvedimas:
	POP		dx						;isismu reiksme is steko
	CMP 	dx, "$$"				;jei randa $$  eina is naujo programa
	JE		IsvedimoSpace
	
	ADD 	dx, 30h					;pridedu prie dx 48(10) kad isvestu butent skaiciaus simboli apgal ascii	
	INT 	21h
	JMP 	Isvedimas
	
;*****ziuriu ar dar liko simboliu kuriu ascii koda reikai apkeisti i desimtaini sakiciu**************;

IsvedimoSpace:
	POP 	cx						;issiima is steko simboliu skaiciu, imeta i cx
	DEC 	cl						;sumazina simboliu skaiciu vienu
	CMP 	cl, 0					;jei cl lygu 0 uzbaigia programa,(reiskiasi akd visu simboliu desimtainius kodus jau isspausdino
	JE 		Pabaiga					
	
	PUSH	cx						;jei dar liko simboliu vel meta i steka ju skaiciu - cx
	
	MOV 	ah, 09h					;rezultate padeda tarpa, kad atsiskirtu simboliu desimtainiai kodai
	MOV 	dx, offset enteris		;rezultate padeda tarpa, kad atsiskirtu simboliu desimtainiai kodai
	INT		21h						;rezultate padeda tarpa, kad atsiskirtu simboliu desimtainiai kodai
	
	INC		bx						;bx padidina vienetu, kad i al imestu kita simboli
	JMP		Idejimas
	
;********************************************************************************************************;		
	
Pabaiga:

	MOV 	ah, 4Ch					;reikalinga kiekvienos programos pabaigoj				
	MOV 	al, 0					;reikalinga kiekvienos programos pabaigoj	
	INT 	21h						;reikalinga kiekvienos programos pabaigoj	
	
END Pradzia
	
	
	