#include "stdafx.h"

#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <GL/glut.h> // OpenGL Graphics Utility Library

using namespace std;

// Number of step
int CurrentNum = 0;
const int MaxNum = 10;

int mode = 0;
int numberOfPoints = 10000;

int spalvinam=1;

// These variables set the dimensions of the rectanglar region we wish to view.
const double Xmin = -0.1, Xmax = 1.1;
const double Ymin = -0.1, Ymax = 1.1;

void myKeyboardFunc( unsigned char key, int x, int y ) {
	switch ( key ) {

	case 'p':
		mode = 0;
		CurrentNum = MaxNum;
		glutPostRedisplay();
	case ' ':
		mode = 1;
		CurrentNum = (CurrentNum + 1) % MaxNum;
		glutPostRedisplay();
		break;
	case 27:
		exit(1);
	}
}

void transform1(int num) {
	if(num == CurrentNum) {
		glColor3f( 1.0, 0.0, 0.0 );
	}

	glTranslatef(0.5,0.5,0.0);
	glRotatef(90, 0,0,1);
	glScalef(0.25,0.25,1.0);
}

void transform2(int num) {
	if(num == CurrentNum) {
		glColor3f( 0.0, 1.0, 0.0 );
	}

	glTranslatef(0.5, 0.5, 0.0);
	glScalef(0.5,0.5,1.0);
}

void transform3(int num) {
	if(num == CurrentNum) {
		glColor3f( 0.0, 0.0, 1.0 );
	}

	glTranslatef(0.0,0.0,0.0);
	glRotatef(-90, 0, 0, 1);
	glRotatef(180, 0, 1, 0);
	glScalef(0.5,0.5,1.0);
}

void transform4(int num){
	if(num == CurrentNum) {
		glColor3f( 1.0, 1.0, 0.0 );
	}

	glTranslatef(1,0.0,0.0);
	glRotatef(180, 0, 1, 0);
	glScalef(0.5,0.5,1.0);
}

void drawFractal(int num) {
	switch(num) {
	case 0:
		glBegin( GL_QUADS );
			glVertex3f( 1.0, 0.0, 0.0 );
			glVertex3f( 1.0, 1.0, 0.0 ); 
			glVertex3f( 0.0, 1.0, 0.0 );
			glVertex3f( 0.0, 0.0, 0.0 );
		glEnd();
		break;
	default:
		glPushMatrix();
		glPushMatrix();
		glPushMatrix();

		//1
		transform1(num);
		drawFractal(num - 1);

		glPopMatrix();//2

		transform2(num);
		drawFractal(num - 1);

		glPopMatrix();//3

		transform3(num);
		drawFractal(num - 1);

		glPopMatrix();//4

		transform4(num);
		drawFractal(num - 1);
		break;   
	}
}

void transformPoint(int depth) {
	if (depth > 0){
		float random = (float)rand()/(float)RAND_MAX;

		if (random <= (1.0/13.0)) {
			transform1(depth);
		} else if (random <= (5.0/13.0)) {
			transform2(depth);
		} else if (random <= (9.0/13.0)) {
			transform3(depth);
		} else {
			transform4(depth);
		}

		depth = depth--;

		transformPoint(depth);
	}
}
void drawPointFractal(int depth, long numberOfPoints){

	for (int i = 0; i < numberOfPoints; i++) {
		glPushMatrix();

		transformPoint(depth);

		glBegin(GL_POINTS);
		glVertex3f(0.0, 0.0, 0.0);
		glEnd();	

		glPopMatrix();
	}
}

void drawScene(void) {
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	if(CurrentNum == 0) {
		glColor3f( 1.0, 1.0, 1.0 );
	}

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	if(mode == 1) {
		drawFractal(CurrentNum);
	} else {
		drawPointFractal(MaxNum, numberOfPoints);
	}

	glFlush();
}

void initRendering() {
	glEnable ( GL_DEPTH_TEST );
}

void resizeWindow(int w, int h) {
	double scale, center;
	double windowXmin, windowXmax, windowYmin, windowYmax;

	// Define the portion of the window used for OpenGL rendering.
	glViewport( 0, 0, w, h ); // View port uses whole window

	// Set up the projection view matrix: orthographic projection
	// Determine the min and max values for x and y that should appear in the window.
	// The complication is that the aspect ratio of the window may not match the
	// aspect ratio of the scene we want to view.
	w = (w==0) ? 1 : w;
	h = (h==0) ? 1 : h;
	if ( (Xmax-Xmin)/w < (Ymax-Ymin)/h ) {
		scale = ((Ymax-Ymin)/h)/((Xmax-Xmin)/w);
		center = (Xmax+Xmin)/2;
		windowXmin = center - (center-Xmin)*scale;
		windowXmax = center + (Xmax-center)*scale;
		windowYmin = Ymin;
		windowYmax = Ymax;
	}
	else {
		scale = ((Xmax-Xmin)/w)/((Ymax-Ymin)/h);
		center = (Ymax+Ymin)/2;
		windowYmin = center - (center-Ymin)*scale;
		windowYmax = center + (Ymax-center)*scale;
		windowXmin = Xmin;
		windowXmax = Xmax;
	}

	// Now that we know the max & min values for x & y that should be visible in the window,
	// we set up the orthographic projection.
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
	glOrtho( windowXmin, windowXmax, windowYmin, windowYmax, -1, 1 );

}

int main( int argc, char** argv )
{
	glutInit(&argc,argv);
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH );
	glutInitWindowPosition( 20, 60 );
	glutInitWindowSize( 500, 500 );
	glutCreateWindow( "SimpleDraw - Press space bar to toggle images" );

	initRendering();

	glutKeyboardFunc( myKeyboardFunc );
	glutReshapeFunc( resizeWindow );
	glutDisplayFunc( drawScene );

	//fprintf(stdout, "Press space bar for the next step; escape button to quit.\n");

	glutMainLoop(  );

	return(0);
}
