
package parduotuve.ui;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.util.List;
import java.util.LinkedList;
import parduotuve.sql.WorkSQL;

public class UserInterface {
    public void runUI() {
        WorkSQL db = new WorkSQL();
        BufferedReader bufRead = new BufferedReader(new InputStreamReader(System.in)); 
        int choice = 1;
        
        printChoices();
        
        while (choice != 0) {
            try {
                System.out.print(">");
                choice = Integer.parseInt(bufRead.readLine());
                
                switch (choice) {
                    case  0: break;
                    case  1: findClientObjects(bufRead, db);
                             break;
                    case  2: addWorker(bufRead, db);
                             break;
                    case  3: updateWorkerSalary(bufRead, db);
                             break;
                    case  4: dismissWorker(bufRead, db);
                             break;
                    default: System.out.println("Blogas pasirinkimas");
                             break;
                }
            } catch (IOException e) {
               System.out.println("Klaida skaitant ivesti");
            } catch(NumberFormatException e) {
               System.out.println("Netinkamas ivesties formatas");
            }
        }
        
        db.closeConnection();
    }
    
    private void printChoices() {
        System.out.println("Meniu:");
        System.out.println("[0] - baigti darba");
        System.out.println("[1] - rasti pirkejo prekiu vienetus");
        System.out.println("[2] - ikurti nauja imone");
        System.out.println("[3] - pakeisti prekes kaina");
        System.out.println("[4] - isimt vieneta is prekybos");
    }
    
    private void findClientObjects(BufferedReader bufRead, WorkSQL db) {
        List<List> result = new LinkedList<List>();
      
        try {
            result = db.queryDb("SELECT * FROM haba0857.Pirkejas");
            
            System.out.println("Pirkejai:");
            for (int i = 0; i < result.size(); i++) {
                System.out.println((String) result.get(i).get(0) + " " + 
                        result.get(i).get(1) + " " + result.get(i).get(2));
            }
            
            System.out.println("Iveskite pirkejo asmens koda:");
            
            result = db.queryDb("SELECT Kodas FROM haba0857.Vienetas, "
                    + "haba0857.Pirkejas WHERE Pirkejas.A_k = Vienetas.A_k AND Pirkejas.A_k = '" + 
                    bufRead.readLine() + "'");
            
            if (result.isEmpty()) {
                System.out.println("Pirkejas su tokiu asmens kodu neturi prekiu vienetu.");
            } else {
                System.out.println("Kliento prekiu vienetai:");
                for (int i = 0; i < result.size(); i++) {
                    System.out.println(result.get(i).get(0));
                }
            }
        } catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }
    
    private void addWorker(BufferedReader bufRead, WorkSQL db) {
        System.out.println("Iveskite naujos imones koda bei pavadinima");
        
        try {
            db.queryDb("INSERT INTO haba0857.Gamintojas VALUES "
                    + "(" + bufRead.readLine() + ",'" + bufRead.readLine() + "')");
        } catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }        
    }
    
    private void updateWorkerSalary(BufferedReader bufRead, WorkSQL db) {
        List<List> result = new LinkedList<List>();
        
        try {
            result = db.queryDb("SELECT * FROM haba0857.Preke");
            
            System.out.println("Prekes:");
            for (int i = 0; i < result.size(); i++) {
                System.out.println((String) result.get(i).get(0) + " " + 
                        result.get(i).get(1) + " " + result.get(i).get(2));
            }
            
            System.out.println("Iveskite nauja prekes kaina ir prekes koda:");
            
            result = db.queryDb("UPDATE haba0857.Preke SET Kaina = " + 
                    bufRead.readLine() + " WHERE Kodas = '" + bufRead.readLine() + "'");
            
        } catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }
    
    private void dismissWorker(BufferedReader bufRead, WorkSQL db) {
        List<List> result = new LinkedList<List>();
        
        try {
            result = db.queryDb("SELECT * FROM haba0857.Vienetas");
            
            System.out.println("Vienetai:");
            for (int i = 0; i < result.size(); i++) {
                System.out.println((String) result.get(i).get(0) + " " + 
                        result.get(i).get(1) + " " + result.get(i).get(2) + 
                        " " + result.get(i).get(3) + " " + result.get(i).get(4) +
                        " " + result.get(i).get(5));
            }
            
            System.out.println("Iveskite vieneto numeri:");
            
            result = db.queryDb("DELETE FROM haba0857.Vienetas WHERE Nr = '" + 
                    bufRead.readLine() +  "'");
            
        } catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }
    
}