package blackjack;

import java.util.*;

public abstract class User {
    
    public String name;
    public Card[] hand= new Card[10];
    public int numCards;
    
    public User(String aName) throws Exception {
        if(aName.length() > 10) {
            throw new Exception();
        }
        name = aName;
        emptyhand();
    }
    
    public void emptyhand() {
        for(int i=0; i<10; i++) {
            hand[i] = null;
        }
    numCards = 0;
    }
    
    public boolean addCard(Card aCard) {
        hand[numCards] = aCard;
        numCards++;
       
        return (getHandSum() <= 21);
    }
    
    public int getHandSum() {
        
        int handSum = 0;
        int cardNum;
        int numAces = 0;
        
        for(int c=0; c<numCards; c++) {
            cardNum = hand[c].getNumber();
            
            if (cardNum == 1) {
                numAces++;
                handSum+= 11;
            } else if (cardNum>10) {
                handSum+= 10;
            } else {
                handSum+= cardNum;
            }
        }
         
        while(handSum>21 && numAces>0) {
            handSum-= 10;
            numAces--;
        }
        
        return handSum;
    }
    
    public void printHand(boolean showFirstCard) {
        System.out.printf("%s kortos:\n", name);
        for(int c=0;c<numCards;c++) {
            if (c==0 && !showFirstCard) {
            System.out.println("  [uzversta]");
            } else {
            System.out.printf("  %s\n", hand[c].toString());        
            }
        }
    }
    
}
