﻿/** Sukurkite klasę Miestas, skirtą vieno miesto duomenims saugoti.
Sukurkite sąrašo elemento struktūrą Mazgas, kurios duomenų laukas
būtų Miestas tipo objektas. Skaitykite duomenis į sąrašą,
kurio pradžios rodyklė Mazgas *M. Iš sąrašo M suformuokite klaviatūra
nurodomos valstybės miestų sąrašą, kurio pradžios rodyklė Mazgas *VM.
Surikiuokite rodyklės VM sąrašą pagal miestų plotus
(mažėjimo kryptimi) ir miestų pavadinimus alfabetiškai burbuliuko
(porinių sukeitimų) būdu. Ekrane spausdinkite lentelėmis duomenis
ir rezultatus prieš ir po rikiavimo.
Parašykite main() funkciją, kurioje atliekami visi
užduotyje nurodyti veiksmai ir po to sunaikinami sąrašai. */

#include <iostream>
#include <fstream>
#include <iomanip>
#include <string>
using namespace std;
const string Cduom = "K2.txt";

class Miestas {
private:
	string salis;
	string miestas;
	double gyvSk;
	double km;
public:
	~Miestas(){};
	Miestas(): salis(""), miestas(""), gyvSk(0.0), km(0.0) {};
	void DetiMiesta(string s, string m, double gs, double k);
	string ImtiSali() {return salis;}
	string ImtiMiesta() {return miestas;}
	double ImtiGyv() {return gyvSk;}
	double ImtiKm() {return km;}
	bool operator > (Miestas & kitas) {return  km > kitas.km || ( km == kitas.km && miestas > kitas.miestas);}
};
//----------------------------------------------------
void Miestas::DetiMiesta(string s, string m, double gs, double k)
{
	salis = s;
	miestas = m;
	gyvSk = gs;
	km = k;
};
//----------------------------------------------------
struct Mazgas 
{
	Miestas ob;
	Mazgas *kitas;
};
//----------------------------------------------------
void Skaitymas(const string Duom, Mazgas *&M);
void Spausdinti(Mazgas *&M);
void Atrinkti(string valstybe, Mazgas *M, Mazgas *&VM);
void Rikiuoti(Mazgas *&VM);
void Naikinti(Mazgas *&M);
//----------------------------------------------------
void main() 
{
	Mazgas *M = NULL;
	Mazgas *VM = NULL;
	Skaitymas(Cduom, M);
	Spausdinti(M);
	string valstybe;
	cout << "Iveskite valstybe" << endl;
	cin >> valstybe;
	Atrinkti(valstybe, M, VM);
	Spausdinti(VM);
	Rikiuoti(VM);
	Spausdinti(VM);
	Naikinti(M);
	Naikinti(VM);
	system("pause");
};
//-------------------------------------------------
void Skaitymas(const string Duom, Mazgas *&M)
{
	Miestas Miest;
	ifstream FD(Cduom);
	string salis, miestas;
	double gyvSk, km;
	Mazgas *d;
	while(!FD.eof())
	{
		d = new Mazgas;
		FD >> ws;
		getline(FD, salis, ',');
		getline(FD, miestas, ',');
		FD >> gyvSk >> ws >> km;
		FD >>ws;
		Miest.DetiMiesta(salis, miestas, gyvSk, km);
		d -> ob = Miest;
		d->kitas = M;
		M = d;
	}
	FD.close();
};
//-----------------------------------------------
void Spausdinti( Mazgas *&M)
{
	cout << "----------------------------------------------------------" << endl;
	cout << setw(10) << left << " Miestas" << setw(10) << left << "Valstybe" << setw(15) << left << "Gyventoju sk" << setw(10) << left << "Km^2" << endl;
	cout << "----------------------------------------------------------" << endl;
	for (Mazgas *d = M; d!= NULL; d = d->kitas)
		cout << setw(10) << left << d->ob.ImtiMiesta() << setw(10) << left << d->ob.ImtiSali()
		<< setw(15) << left << d->ob.ImtiGyv() << setw(10) << left << d->ob.ImtiKm() << endl;
	cout << "----------------------------------------------------------" << endl;
}
//---------------------------------------------------
void Atrinkti(string valstybe, Mazgas *M, Mazgas *&VM)
{
	Mazgas *DD;
	for (Mazgas *d = M; d!= NULL; d = d->kitas)
		if (d->ob.ImtiSali() == valstybe)
		{
			Miestas pag = d->ob;
			DD =new Mazgas;
			DD->ob = pag;
			DD->kitas = VM;
			VM = DD;
		}
};
//------------------------------------------------
void Rikiuoti(Mazgas *&VM)
{
	if (VM == NULL) return;
	bool keista = true;
	while (keista)
	{
		keista = false;
		Mazgas *d = VM;
		while(d->kitas !=NULL)
		{
			Miestas A = d ->ob;
			Miestas B = d->kitas->ob;
			if (B > A){
				d->ob = B;
				d->kitas->ob = A;
				keista = true;
			}
			d = d->kitas;
		}
	}
};
//---------------------------------------------
void Naikinti(Mazgas *&M)
{
	while(M) {
	Mazgas *d = M;
	M=M->kitas;
	delete d;
	}
}
//-------------------------------------------



