import java.util.List;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class POP3Client {

private Socket sslSocket = null;

private boolean debug = false;
private String body;

private BufferedReader reader;
private BufferedWriter writer;

private static final int DEFAULT_PORT = 995;

public boolean isDebug() {
return debug;
}

public void setDebug(boolean debug) {
this.debug = debug;
}

/* ********************** connect method *************************** */

public void connect(String host, int port) throws IOException {
	
SocketFactory socketFactory = SSLSocketFactory.getDefault();
sslSocket = socketFactory.createSocket(host, port);

reader = new BufferedReader(new InputStreamReader(sslSocket.getInputStream()));
writer = new BufferedWriter(new OutputStreamWriter(sslSocket.getOutputStream())); 

if (debug)
System.out.println("Connected to the host");
readResponseLine();
}

/* ******************** connect using default port ****************** */

public void connect(String host) throws IOException {
connect(host, DEFAULT_PORT);
}

/* ************* method to check if client is connected to server ************* */

public boolean isConnected() {
return sslSocket != null && sslSocket.isConnected();
}

/* ********************* disconnect method ******************** */

public void disconnect() throws IOException {
if (!isConnected())
throw new IllegalStateException("Not connected to a host");
sslSocket.close();
reader = null;
writer = null;
if (debug)
System.out.println("Disconnected from the host");
}

/* ********* method to recieve and read msg from server **************** */

protected String readResponseLine() throws IOException{
String response = reader.readLine();
if (response == null) {
    throw new EOFException("CONNECTION closed without indication.");
}
if (debug) {
System.out.println("DEBUG [in]  " + response);
}
if (response.startsWith("-ERR")){
throw new RuntimeException("Server has returned an error: " + response.replaceFirst("-ERR ", ""));
   } 
return response;
}

/* *********** sending command to server ************** */

protected String sendCommand(String command) throws IOException {
if (debug) {
System.out.println("DEBUG [out]: " + command);
}
writer.write(command + "\n");
writer.flush();
return readResponseLine();
}

/* ********** login and logout *********** */

public void login(String username, String password) throws IOException {
sendCommand("USER " + username);
sendCommand("PASS " + password);
}

public void logout() throws IOException {
sendCommand("QUIT");
}


/* ********** number of messages ************* */
public int getNumberOfNewMessages() throws IOException {
String response = sendCommand("STAT");
String[] values = response.split(" ");
return Integer.parseInt(values[1]);
}

protected Message getMessage(int i) throws IOException {
String response = sendCommand("RETR " + i);
Map<String, List<String>> headers = new HashMap<String, List<String>>();
String headerName = null;

/* processing headers */
while ((response = readResponseLine()).length() != 0) {
if (response.startsWith("\t")) {
continue; 
}
int colonPosition = response.indexOf(":");
if (colonPosition < 0) { 
	colonPosition = 0;
} 
headerName = response.substring(0, colonPosition);
String headerValue;
if (response.length() > colonPosition) {
headerValue = response.substring(colonPosition + 2);
} else {
headerValue = "";
}
List<String> headerValues = headers.get(headerName);
if (headerValues == null) {
headerValues = new ArrayList<String>();
headers.put(headerName, headerValues);
}
headerValues.add(headerValue);
} 

/* processing body */

StringBuilder bodyBuilder = new StringBuilder();
while (!(response = readResponseLine()).equals(".")) {
bodyBuilder.append(response + "\n");
}
return new Message(headers, bodyBuilder.toString());
}


public List<Message> getMessages() throws IOException {
int numOfNewMessages = getNumberOfNewMessages();
List<Message> messageList = new ArrayList<Message>();
for (int i = 1; i <= numOfNewMessages; i++) {
messageList.add(getMessage(i));
}
return messageList;
}

/* *********************** command LIST (with argument) ***************** */

public void listCommandWithArgument(int i) throws IOException {
sendCommand("LIST " + i);
}


/* *********************** command LIST (without argument) ***************** */

public void listCommand() throws IOException {
int noOfMsg = getNumberOfNewMessages(); 
sendCommand("LIST");
for (int i = 0; i <= noOfMsg; i++){
	readResponseLine();	
}
}

/* *************** command DELE *********************** */

public void deleCommand(int i) throws IOException{
 sendCommand("DELE " + i);
}

/* *********** command NOOP ******************* */

public void noopCommand() throws IOException{
 sendCommand("NOOP");
}

/* **************** command RSET ************** */

public void rsetCommand() throws IOException{
 sendCommand("RSET");
}

public String getBody() {
	StringBuilder bodyBuilder = new StringBuilder();
return bodyBuilder.toString();
}



}