#include <iostream>
#include <stdlib.h>
#include <string>
#include <cctype>

using namespace std;

struct Node {
	int data;
	Node* next;
};

Node* stekas = NULL;

void push (int i){
	Node* p = new Node();
    p->data = i;
    p->next = stekas;
    stekas = p;
}

//+++
bool isOperator (char c){
    if ((c == '*') || (c == '/') || (c == '-') || (c == '+')){
        return true;
    } else {
        return false;
    }
}

//++++
bool isNumber(char c){
    if ((c == '0') || (c == '1') || (c == '2') || (c == '3') || (c == '4') || (c == '5') || (c == '6') || (c == '7') || (c == '8') || (c == '9')) {
        return true;
    } else {
        return false;
    }
}

//+++
bool isEmpty(Node* s)
    {
        return ( s == NULL ) ? true : false;
    }

//+++
int pop() {
    if (!isEmpty(stekas)) {
        int ret = stekas->data;
        Node* p = stekas->next;
        delete stekas;
        stekas = p;
        return ret;
    } else {
        cout << "Stekas tuscias. Nera ka isimti. Bloga ivestis" << endl;
    }
}

void print(){
	Node* p = stekas;
    while (p != NULL) {
        cout << p->data << endl;
        p = p->next;
    }
}

// kazkas cia negerai
void evaluateExpression(string data){
    for (int i = 0; i < data.length(); i++){
        if (isNumber(data[i])){
            push(data[i]-48);
        }
        if (isOperator(data[i])){
            if (data[i] == '+'){
               push(pop() + pop());
            }
            if (data[i] == '*'){
               push(pop() * pop());
            }
            if (data[i] == '/'){
               push(pop() / pop());
            }
            if (data[i] == '-'){
               push(pop() - pop());
            }
        } else {
            cout << "Blogai ivedet" << endl;
        }
    }

}


int main(int argc, char *argv[]) {
    string data;
    cin >> data;
    evaluateExpression(data);
    cout << pop() << endl;
	return 0;
}
