package adt;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ADT {

    public int kiekis;
    private double kaina;
    public boolean busena;
    private char klase;
    private String pavadinimas;

    private Irasas[] adt;

    public static void main(String[] args) {

        ADT programa = new ADT();
        programa.initialize();
        System.out.println("Pradinis sarasas: ");
        System.out.println("");
        programa.print();
        System.out.println("Iterpia ivesta elementa i eilute: ");
        programa.put();
        System.out.println("");
        programa.print();
        System.out.println("Pasalina seniausia elementa is eilutes: ");
        programa.get();
        programa.print();
        System.out.println("Isspausdinamas seniausias elementas: ");
        programa.head();
        System.out.println("Sunaikinamas sarasas: ");
        programa.kill();
        programa.print();
    }

    public void initialize() {
        int n = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader("duom.txt"));
            n = Integer.parseInt(reader.readLine());
            this.adt = new Irasas[n];
            for (int i = 0; i < n; i++) {
                adt[i] = new Irasas(Integer.parseInt(reader.readLine()), Double.parseDouble(reader.readLine()), Boolean.parseBoolean(reader.readLine()), reader.readLine().charAt(0), String.valueOf(reader.readLine()));
            }
        } catch (FileNotFoundException ex) {
            Logger.getLogger(ADT.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(ADT.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void put() {
        System.out.println("Iveskite duomenis kuriais norite papildyti: ");
        Scanner input = new Scanner(System.in);
        Irasas duomenys = new Irasas(input.nextInt(), input.nextDouble(), input.nextBoolean(), input.next().charAt(0), input.next());
        if (adt[0] != null) {
            boolean isFull = false;
            for (Irasas element : adt) {
                if (element == null) {
                    isFull = false;
                } else {
                    isFull = true;
                }
            }
            if (isFull) {
                Irasas[] adt1 = adt;
                adt = new Irasas[adt.length + 1];
                for (int i = adt.length - 1; i > 0; i--) {
                    adt[i] = adt1[i - 1];
                }
            } else {
                for (int i = adt.length - 2; i > 0; i--) {
                    adt[i + 1] = adt[i];
                }
            }
            adt[0] = duomenys;
        } else {
            adt[0] = duomenys;
        }
    }

    public void get() {
        int i = 0;
        boolean isFull = false;
        for (Irasas element : adt) {
            if (element == null) {
                isFull = false;
            } else {
                isFull = true;
            }
        }
        if (isFull) {
            adt[adt.length - 1] = null;
        } else {
            while (adt[i] != null) {
                if (adt[i + 1] == null) {
                    adt[i] = null;
                }
                i++;
            }
        }

    }

    public void head() {
        int i = 0;
        boolean isFull = false;
        for (Irasas element : adt) {
            if (element == null) {
                isFull = false;
            } else {
                isFull = true;
            }
        }
        if (isFull) {
            System.out.println("Paskutinis elementas: " + adt[adt.length - 1]);
        } else {
            while (adt[i] != null) {
                if (adt[i + 1] == null) {
                    System.out.println("Paskutinis elementas: " + adt[i]);
                }
                i++;
            }

        }
    }

    public void kill() {
        adt = null;
    }

    public void print() {
        if (adt != null) {
            for (Irasas element : adt) {
                System.out.println(element);
            }
        } else {
            System.out.println("Nera ka spausdinti");
        }
    }
}
