#include <stdio.h>
#include <stdlib.h>
#include "stack.h"

void sukurti(STEK *Stekas, ERRMSG *Error){

    if(*Stekas != NULL){
        *Error = "Stekas jau yra sukurtas!\n";
        return;
    }

    if(NULL==(*Stekas = (STEK)malloc(sizeof(struct Stek)))){
        *Error = "Nebeliko atminties!\n";
        return;
    }

    (*Stekas)->pradzia = NULL;
    (*Stekas)->pabaiga = NULL;
    (*Stekas)->elementuSkaicius = 0;

    *Error = "";

}

void ideti(STEK Stekas, skaiciausTipas skaicius, ERRMSG *Error){

    if(Stekas == NULL){
        *Error = "Stekas dar nesukurtas!\n";
        return;
    }

    STEKELEM elem;

    if(NULL == (elem = (STEKELEM)malloc(sizeof(struct StekElem)))){
        *Error = "Nebeliko atminties!\n";
        return;
    }

    elem->reiksme = skaicius;
    elem->kitas = Stekas->pradzia;
    Stekas->pradzia = elem;
    Stekas->elementuSkaicius++;

    if(Stekas->pabaiga == NULL){
        Stekas->pabaiga = elem;
    }

    *Error = "";
}

void isimti(STEK Stekas, skaiciausTipas *popValue, ERRMSG *Error){

    if(Stekas == NULL){
        *Error = "Stekas dar nesukurtas!\n";
        return;
    }

    STEKELEM elem;
    elem = Stekas->pradzia;

    if(elem == NULL){
        *Error = "Stekas yra tuscias!\n";
        *popValue = DEFVAL;
        return;
    }

    *popValue = elem->reiksme;
    Stekas->pradzia = elem->kitas;

    Stekas->elementuSkaicius--;

    free(elem);

    *Error = "";
}

int elementuKiekis(STEK Stekas, ERRMSG *Error){

    if(Stekas == NULL){
        *Error = "Stekas dar nesukurtas!\n";
        return;
    }

    return Stekas->elementuSkaicius;

    *Error = "";
}

bool arTuscias(STEK Stekas, ERRMSG *Error){

    if(Stekas == NULL){
        *Error = "Stekas dar nesukurtas!\n";
        return;
    }

    *Error = "";

    if(Stekas->elementuSkaicius == 0) return true;
    else return false;
}

bool arPilnas(STEK Stekas, ERRMSG *Error){

    if(Stekas == NULL){
        *Error = "Stekas dar nesukurtas!\n";
        return;
    }

    STEKELEM elem;

    if(NULL == (elem = (STEKELEM)malloc(sizeof(struct StekElem)))){
        *Error = "Nebeliko atminties!\n";
        return;
    }
    *Error = "";
    return false;
}

void valyti(STEK Stekas, ERRMSG *Error){

    if(Stekas == NULL){
        *Error = "Stekas dar nesukurtas!\n";
        return;
    }

    if(Stekas->pradzia == NULL){
        *Error = "Nera ka valyti!\n";
        return;
    }

    STEKELEM elem, elem1;

    while(elem != Stekas->pabaiga){
        elem = Stekas->pradzia;
        elem1 = elem->kitas;
        Stekas->pradzia = elem1;
        free(elem);
    }

    Stekas->elementuSkaicius = 0;

    free(Stekas->pradzia);
    free(Stekas);

    *Error = "";
}

