;----------------------------------------------------------------------------------------------
; Asemblerio iseities tekstu syntax highlight'as. Skaito asemblerio iseities teksta, 
; raso validu HTML faila, kuriame vaizduojamas tas asemblerinis failas nuspalvinant 
; sintakses elementus: 
;   + zymes,           label:
;   + instrukcijas,    mov, cmp
;   + registrus,       ax, bh, ds
;   + betarpiskus operandus ir 0Ah, 123
;   + eiluciu literalus, "eil", 'ute'
;   + komentarus.        ; komentaras
;----------------------------------------------------------------------------------------------
.MODEL small
.STACK 20h 
.DATA  
help_msg db ' _________________________________________________________________ ',0Dh,0Ah 
         db '|                     Darba atliko Viktorija                      |',0Dh,0Ah
         db '| Programa nuskaito asemblerio faila ir isveda pazymeta teksta    |',0Dh,0Ah
         db '| html formato faile.                                             |',0Dh,0Ah
         db '|      Programos naudojimo pvz:                                   |',0Dh,0Ah
         db '| c:> antra.exe asemblerio_kodas.asm html_failas.htm              |',0Dh,0Ah
      db 27h,'-----------------------------------------------------------------',27h,0Dh,0Ah,'$'
html1 db '<!DOCTYPE html>', 0Dh, 0Ah, '<html>', 0Dh, 0Ah  ; 25 bytes
html2 db '</html>'          ; 7B 
head1 db '<head><title>'    ; 13B
head2 db '</title>',0Dh,0Ah,'<style type="text/css">',0Dh,0Ah  ; 35B
css_1 db '.i{color:#0000FF;}',0Dh,0Ah   ; 20B  instruction
css_2 db '.r{color:#FF0000;}',0Dh,0Ah   ;      register
css_3 db '.s{color:#880088;}',0Dh,0Ah   ;      string
css_4 db '.c{color:#008800;}',0Dh,0Ah   ;      comment
css_5 db '.l{color:#0088FF;}',0Dh,0Ah   ;      label
css_6 db '.o{color:#FF8800;}',0Dh,0Ah   ;      operand
body1 db '</style></head>',0Dh,0Ah,'<body><pre>'  ; 28B
body2 db '</pre></body>', 0Dh, 0Ah  ; 15B
span1 db '<span class=".">'  ; 16B
span2 db '</span>'          ; 7B
error_msg  db 'Ivyko klaida.',0Dh,0Ah,24h
; zodziai tik DIDZIOSIOMIS ir po kiekvieno turi bbuti tarpas (SPACE), o pabaigos simbolis - 0h
registers db 'AX AH AL BX BH BL CX CH CL DX DH DL SI DI ', 0h
instructs db 'MOV LEA CMP JMP JNE JE JLE JGE AND OR PUSH POP INC DEC CALL INT XOR ', 0h
filename_asm db 10 dup(0)  ; failu pavadinimas
filename_htm db 10 dup(0)
handle_asm dw 0            ; atidarytu failu rodykles
handle_htm dw 0
e_char db 0  ; ending character - reikalingas kabutems
char db 0    ; nuskaitomas simbolis 
aword  db 255 dup(0)  ; nuskaitytas zodis
bword  db 255 dup(0)  ; nuskaitytas zodis didziosiomis
w_len dw 0            ; zodzio ilgis
mark_ch db 0  ; css klases simbolis rasomas i  <span class=".">
 
.CODE 
;***********************************************************************************
;    PROCEDUROS                                                                  *
;***********************************************************************************

;-- parametru paemimas -------------------------------------------------------------
arguments proc near
    mov ax, @data
    mov es, ax   ; es kad galetume naudot stosb funkcija 
               
    mov si, 81h
 
  find_param:
    lodsb         ; skaitomas baitas is komandines eil, vykdomos komandas:  mov al, [si]  ir  inc si
    cmp al, 0Dh   ; 0Dh parametru eilutes pabaigos simbolis [enter]
    je  set_help  ; jeigu parametrai nenurodyti
    cmp al, ' '   ; praleidziami tarpai pradzioje
    je find_param  ; jeigu TARPAS kartojam dar kart
    
    dec si        ; griztam atgal, kad si rodytu i pirma simboli kuris nera SPACE
    
    mov    ax, [si]        ;i ax isirasom du baitus, i kuriuos rodo registras si
    cmp    ax, 3F2Fh        ;o gal nuskaityta "/?" - 3F = '?'; 2F = '/'
    je set_help                 ;radau "/?", vadinasi turiu isvesti pagalba
    
    lea di, filename_asm   ; pirma parametra saugosim i kintamaji filename_asm
    xor cx, cx    ; cx skaiciuos asm failo pavadinimo ilgi
    xor bx, bx
    
  param1:
    lodsb      ;  tas pats kaip komandos:  mov al, [si]  ir  inc si
         
    cmp al, 0Dh  ; 0Dh parametru eilutes pabaigos simbolis
    je  set_help   
    cmp al, ' '  ; randamas skirtukas (tarpas tarp 1-o ir 2-o parametru 
    je spaces
    
    ; perkopijuoja simboli i filename_asm
    stosb
    inc cx
    jmp param1 
    
  spaces:
    lodsb      ;  tas pats kaip komandos:  mov al, [si]  ir  inc si
         
    cmp al, 0Dh  ; 0Dh parametru eilutes pabaigos simbolis
    je  set_help     ; tik vienas parametras                                                        
    cmp al, ' '  ; randamas skirtukas (tarpas tarp 1-o ir 2-o parametru 
    je spaces
    
    lea di, filename_htm
       
  param2:
    stosb      ; perkopijuoja simboli mov [di], AL  ir  inc di

    lodsb      ;  tas pats kaip komandos:  mov al, [si]  ir  inc si
         
    cmp al, 0Dh  ; parametru pabaiga ir rasti 2 parametrai
    je  params_ok                                                          
    cmp al, ' '  ; tarpai - like parametrai ignoruojami
    je  params_ok
    
    jmp param2  
       
  set_help:
    mov al, 0   ; al = 0 - show help
    ret
     
  params_ok:
    push es
    pop ds
    mov w_len, cx   ; issaugojame failo pavadinimo ilgi  w_len
    mov al, 1  ; al = 1 - du+ parametrai
    
    ret
endp arguments


; procedura isveda pagalbos pranesima
show_help proc near
    lea dx, help_msg
    mov ah, 09h
    int 21h                          
    
    ret
endp show_help


; --- rasomas HTML failo virsus --------------------------------------------------------
write_html_1 proc near
	; HTML kodo rasymas i faila
    mov bx, handle_htm
    mov ah, 40h
    mov cx, 25
    lea dx, html1
    int 21h
    
    mov ah, 40h
    mov cx, 13
    lea dx, head1
    int 21h    
    
    mov ah, 40h          ; title raomas asm failo pavadinimas
    mov cx, w_len
    lea dx, filename_asm
    int 21h
    
    mov ah, 40h
    mov cx, 35
    lea dx, head2
    int 21h  
    
    mov ah, 40h
    mov cx, 120        ; kadangi is eiles, tai visus 6 (css_1-css_6) iraso i faila vienu kartu
    lea dx, css_1
    int 21h
    
    mov ah, 40h
    mov cx, 28
    lea dx, body1
    int 21h  

	ret
endp    

; --- rasoma HTML failo apacia -----------------------------------------------------------------------
; --- ir uzdaromas HTML failas
write_html_2 proc near
    mov bx, handle_htm
    mov ah, 40h
    mov cx, 13
    lea dx, body2
    int 21h
    
    mov ah, 40h
    mov cx, 7
    lea dx, html2
    int 21h
    
    ; failo uzdarymas
    ;mov bx, handle_htm
    xor ax, ax
    mov ah, 3Eh   ; failo uzdarymo fukncija
    int 21h

	ret
endp   

;-------------------------------------
;  zymi simboliu eilute ".." arba '..'
;-------------------------------------
mark_string proc near
    lea di, span1[0Dh]
    mov byte ptr [di], 's' 
    
    mov bx, handle_htm
    mov ah, 40h
    mov cx, 16
    lea dx, span1
    int 21h     
    
  quotes:  ; single/double quotes
    call write_char
    
    call read_char

    cmp ax, 00h
    je str_eof
    
    mov al, e_char
    cmp char, al
    jne quotes 
    
    call write_char
  
    mov bx, handle_htm
    mov ah, 40h
    mov cx, 7
    lea dx, span2
    int 21h  
    xor al, al

    ret

  str_eof:
    mov al, 1
    ret
endp mark_string     


;-------------------------------------
;  skaito ir pazymi komentara
;-------------------------------------
mark_comment proc near 
    lea di, span1[0Dh]
    mov byte ptr [di], 'c' 
    
    mov bx, handle_htm
    mov ah, 40h
    mov cx, 16
    lea dx, span1
    int 21h         
    
  coment:    
    call write_char
    
    call read_char

    cmp ax, 00h
    je com_eof
    
    cmp char, 0Dh
    jne coment
    
    mov bx, handle_htm
    mov ah, 40h
    mov cx, 7
    lea dx, span2
    int 21h  
    
    call write_char 

  com_eof:
    ret
endp mark_comment

;------------------------------------------------
; nuskaito betrapini operand - 0dh, 123, ir pan.
;---
read_operand proc near
    ; neigyvendintas metodas
endp read_operand

;------------------------------------
; pazymi zodi span su nurodyta klase
;------------------------------------
mark_word proc near       
    mov bx, handle_htm
    
    lea di, span1[0Dh]
    mov byte ptr [di], al 
    
    mov ah, 40h
    mov cx, 16
    lea dx, span1
    int 21h  
    
    mov ah, 40h
    mov cx, w_len
    lea dx, aword
    int 21h    
    
    mov ah, 40h
    mov cx, 7
    lea dx, span2
    int 21h 
    
    ret
endp mark_word


         
is_digit proc near
    cmp char, 30h
    jl not_dig
    cmp char, 39h
    jg not_dig
    mov al, 1
    ret
  not_dig:
    mov al, 0
    ret
endp

is_alpha proc near
    cmp char, 'A'
    jb not_alpha
    cmp char, 'Z'
    jbe alpha
    cmp char, 'a'
    jb not_alpha
    cmp char, 'z'
    jbe alpha 
    jmp not_alpha
  alpha:  
    mov al, 1
    ret
  not_alpha:
    mov al, 0
    ret
endp 

is_word_char proc near
    call is_alpha
    cmp al, 1
    je wc
    call is_digit
    cmp al, 1
    je wc
    cmp char, '_'
    je wc  
    
  n_wc:  
    mov al, 0
    ret
  wc: 
    mov al, 1
    ret
endp is_word_char
                
read_char proc near
    mov bx, handle_asm
    mov ah, 3Fh     ; AH = 3Fh - read from file                        
    mov cx, 01h
    lea dx, char    ; bus nuskaitomas 1 baitas i char
    int 21h   
    ret
endp 

write_char proc near
    mov bx, handle_htm
    mov ah, 40h
    mov cx, 1
    lea dx, char
    int 21h    
    ret
endp 
; pavercia zodzio raides didziosiom
to_upper proc near
    ; zodis paverciamas diziosiom raidem
    lea si, aword
    lea di, bword    
    mov cx, w_len
  copys:
    mov dl, [si]
    cmp dl, 60h
    jb cp2
    sub dl, 20h
  cp2:
    mov [di], dl
    inc si
    inc di
    loop copys
    
    ret
endp to_upper
; iesko zodzio raktazodziu sarase
has_word proc near
    
    push si
    call to_upper
    pop si
    
    ; ieskoma zodzio instrukciju sarase
    ;lea si, instructions
    xor ax, ax      ; nunulinamas cia kad nereiktu kas kart to daryt cikle find
  find_w:
    mov cx, w_len
    lea di, bword
  find:           
    mov al, [si]
    cmp al, [di]
    jne skip
    inc si
    inc di
    loop find  
    
    ; xor ax, ax
    mov al, [si]
    sub al, 20h
    or cx, ax
    jz found
    
  ;  cmp byte ptr [si], 0h
    jne find_w
    
  skip:            ; praleidziama likusi instrukcijos dalis
    cmp byte ptr [si], 20h
    je next_instr 
    cmp byte ptr [si], 0h
    je not_found
    inc si
    jmp skip  
  next_instr:   ; praleidziamas SPACE
    inc si
    jmp find_w    
    
not_found:
    mov al, 0
    ret
    
found:
    mov al, 1    
    ret
endp

; --- isejimas is programos 
exit_pro proc near
    mov ah, 4Ch
    mov al, 00h
    int 21h      
endp exit_pro


START:           
   
    call arguments

    mov bx, @data
    mov ds, bx   ; nustatome duomenu segmenta
    
    cmp al, 0h
    jne open_files
            
    ; kai nenurodytai parametrai arba ivesta /? - isvedama pagalba
    call show_help
    
    call exit_pro
    ;mov ax, 4C00h
    ;int 21h 
    
;----------------------------------------------------------------------------------------------
;-- failu atidarymas --------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
open_files:
    lea dx, filename_asm
    mov ah, 3Dh     ; 3Dh - failo atidarymas 
    mov al, 00h     ; 00h - skaitymui
    int 21h
    
    mov handle_asm, ax
    jc fopen_error
    
    lea dx, filename_htm
    xor ax, ax
    mov ah, 3Ch     ; 3dh - failo sukurimas arba isvalymas
    mov cx, 00h     ; 00h - normal - be atributu
    int 21h
    
    mov handle_htm, ax
    jc fopen_error  
    
    jmp html_1
    
fopen_error:
    lea dx, show_error_msg
    mov ah, 09h 
    int 21h       
    
    call exit_pro
        
html_1:
    call write_html_1
    
;----------------------------------------------------------------------------------------------
;-- asemblerio kodo analizavimas --------------------------------------------------------------
;----------------------------------------------------------------------------------------------
read:
    call read_char
    
    cmp ax, 00h
    je end_of_file
    jc show_error_msg
    
test1: ; ar eilute ""             
    cmp char, 22h  ; " - double quote 
    jne test2    
    
    ; eiluite "asdf"
    mov e_char, 22h

    call mark_string    
    
    cmp al, 0
    jne end_of_file
    
    jmp read  
    
test2: ; ar eilute ''           
    cmp char, 27h  ; ' - single quote
    jne test3
    mov e_char, 27h
    
    ; eilute 'asdf'
    call mark_string  
    
    cmp al, 0
    jne end_of_file
    
    jmp read
             
test3: ; ar komentaras
    cmp char, 3Bh  ; ; - kabliataskis
    jne test4
    
    ; komentaras
    call mark_comment            
    cmp al, 1
    je  end_of_file
    
    jmp read           
   
test4: ; ar skaitmuo
    call is_digit
    cmp al, 1
    jne test5   

    xor cx, cx 
    mov w_len, cx
    lea di, aword    
    mov ah, char
    mov [di], ah
    inc di
    inc w_len
    
operand:    
    call read_char
    ;call is_digit
    call is_word_char
    cmp al, 1      
    jne operand_end
    mov ah, char
    mov [di], ah
    inc di  
    inc w_len       
    jmp operand
    
operand_end: 
    mov al, 'o'
    call mark_word
    
    ; dar lieka vienas simbolis nuskaitytas po operando, kuri reiks tikrinti
    jmp test1 

test5:  ; ar odis
    call is_alpha
    cmp al, 1
    jne other_char   

    xor cx, cx      ; raomas nulis  w_len
    mov w_len, cx
    lea di, aword    
    mov ah, char
    mov [di], ah
    inc di
    inc w_len
word_char:
    call read_char
    ;call is_alpha
    call is_word_char
    cmp al, 1      
    jne word_char_end   
    
    mov ah, char
    mov [di], ah
    inc di  
    inc w_len       
    jmp word_char  
    
word_char_end:  
    lea si, instructs
    call has_word
    cmp al, 1
    ;jne write_word
    je m_instruction
    
    lea si, registers
    call has_word
    cmp al, 1
    jne simple_word
    
    mov al, 'r'
    call mark_word
    jmp sw_end 
    
m_instruction: 
    mov al, 'i'
    call mark_word   
    jmp sw_end
    
simple_word:  
    ; ar ym, label (sekantis simbolis :) 
    cmp char, 3Ah  ; : - dvitaskis  
    jne write_word
    
    mov al, 'l'
    call mark_word
    call write_char      
    
    jmp read 
    
write_word:
    mov bx, handle_htm
    mov ah, 40h
    mov cx, w_len
    lea dx, aword
    int 21h 
    
sw_end:         
    ; lieka vienas simbolis nuskaitytas po zodzio, kuri reikia tikrint
    jmp test1   

other_char:
    call write_char
    jmp read

end_of_file:    
;html_end:      
    call write_html_2
    cmp al, 0h
    jne show_error_msg
  
    call exit_pro
  
show_error_msg:
    lea dx, error_msg
    mov ah, 09h
    int 21h
   
    call exit_pro
    
               
END START
