import java.io.*;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

import static java.lang.System.exit;

public class TFTPClientNet {

    private static final String TFTP_SERVER_IP = "127.0.0.1"; // local ip
    private static final int TFTP_DEFAULT_PORT = 69;

    // TFTP OP code
    private static final byte OP_RRQ = 1; // read byte
    private static final byte OP_RWQ = 2;  // write byte
    private static final byte OP_DATAPACKET = 3; // date byte
    private static final byte OP_ACK = 4; // Acknowledgment  byte
    private static final byte OP_ERROR = 5; // Error byte

    private final static int PACKET_SIZE = 516; // Size of packet that we get

    private DatagramSocket datagramSocket = null;
    private InetAddress inetAddress = null;
    private byte[] requestByteArray;
    private byte[] bufferByteArray;
    private DatagramPacket outBoundDatagramPacket;
    private DatagramPacket inBoundDatagramPacket;

    public static void main(String[] args) throws IOException {
        String fileName = "test2.pdf";
        TFTPClientNet tFTPClientNet = new TFTPClientNet();
        tFTPClientNet.get(fileName);
    }

    private void get(String fileName) throws IOException {

        // STEP0: prepare for communication
        inetAddress = InetAddress.getByName(TFTP_SERVER_IP);
        datagramSocket = new DatagramSocket(); // DatagramSocket class represents a connection-less socket
        // for sending and receiving datagram packets.
        requestByteArray = createRequest(OP_RRQ, fileName, "octet"); // octet (This replaces the "binary" mode
        // of previous versions of this document.) raw 8 bit bytes

        outBoundDatagramPacket = new DatagramPacket(requestByteArray,
                requestByteArray.length, inetAddress, TFTP_DEFAULT_PORT);

        // STEP 1: sending request RRQ to TFTP server fo a file
        datagramSocket.send(outBoundDatagramPacket);


        // STEP 2: receive file from TFTP server
        ByteArrayOutputStream byteOutOS = receiveFile();

        // STEP 3: write file to local disc
        writeFile(byteOutOS, fileName);




        //sendFile(new File(fileName));
    }

    private ByteArrayOutputStream receiveFile() throws IOException {
        ByteArrayOutputStream byteOutOS = new ByteArrayOutputStream();
        int block = 1;
        do {
            System.out.println("TFTP Packet count: " + block);
            block++;
            bufferByteArray = new byte[PACKET_SIZE];
            inBoundDatagramPacket = new DatagramPacket(bufferByteArray,
                    bufferByteArray.length, inetAddress,
                    datagramSocket.getLocalPort());

            //STEP 2.1: receive packet from TFTP server
            datagramSocket.receive(inBoundDatagramPacket);

            // Getting the first 4 characters from the TFTP packet
            byte[] opCode = { bufferByteArray[0], bufferByteArray[1] };

            if (opCode[1] == OP_ERROR) {
                reportError();
            } else if (opCode[1] == OP_DATAPACKET) {
                // Check for the TFTP packets block number
                byte[] blockNumber = { bufferByteArray[2], bufferByteArray[3] };

                DataOutputStream dos = new DataOutputStream(byteOutOS);
                dos.write(inBoundDatagramPacket.getData(), 4,
                        inBoundDatagramPacket.getLength() - 4);

                //STEP 2.2: send ACK to TFTP server for received packet
                sendAcknowledgment(blockNumber);
            }

        } while (!isLastPacket(inBoundDatagramPacket));
        return byteOutOS;
    }

    private void sendFile(File myFile) throws IOException {

        int block = 0;
        RandomAccessFile f = new RandomAccessFile(myFile, "r");
        byte[] b = new byte[(int)myFile.length()];
        f.readFully(b);

        if(b.length > 254*516){
            System.out.println("ERROR FILE TOO BIG!");
            exit(0);
        }

        System.out.println("Size: " + b.length);

        byte[] buffer;

        buffer = new byte[] {0, OP_DATAPACKET, 0, (byte) block};


        ByteArrayOutputStream outputStream = new ByteArrayOutputStream( );
        outputStream.write( buffer );
        outputStream.write( b );

        byte[] c = outputStream.toByteArray( );

        System.out.println("Size: " + c.length);

        bufferByteArray = new byte[4];
        inBoundDatagramPacket = new DatagramPacket(bufferByteArray,
                bufferByteArray.length, inetAddress,
                datagramSocket.getLocalPort());


        DatagramPacket send1 = new DatagramPacket(c, c.length, inetAddress,
                inBoundDatagramPacket.getPort());
        try{
            datagramSocket.send(send1);
        }catch (IOException e){
            e.printStackTrace();
        }



        datagramSocket.receive(inBoundDatagramPacket);

        System.out.println("Size of ACK:" + bufferByteArray.length);
        /*

        bufferByteArray = new byte[PACKET_SIZE];
            inBoundDatagramPacket = new DatagramPacket(bufferByteArray,
                    bufferByteArray.length, inetAddress,
                    datagramSocket.getLocalPort());

            //STEP 2.1: receive packet from TFTP server
            datagramSocket.receive(inBoundDatagramPacket);

            // Getting the first 4 characters from the TFTP packet
            byte[] opCode = { bufferByteArray[0], bufferByteArray[1] };

         */



        // sukuriam buferi, pirmi 4 baitai, kiti 512 failo baitu
        // nusiunciam, gaunam 4 baitus ACK
        // siunciam vel

        /*
        do{


            DatagramPacket send1 = new DatagramPacket(buffer, buffer.length, inetAddress,
                    inBoundDatagramPacket.getPort());
            try{
                datagramSocket.send(send1);
            }catch (IOException e){
                e.printStackTrace();
            }



        }while()
        */


    }

    private void sendAcknowledgment(byte[] blockNumber) {

        byte[] ACK = { 0, OP_ACK, blockNumber[0], blockNumber[1] };

        // TFTP Server communicates back on a new PORT
        // so get that PORT from in bound packet and
        // send acknowledgment to it
        DatagramPacket ack = new DatagramPacket(ACK, ACK.length, inetAddress,
                inBoundDatagramPacket.getPort());
        try {
            datagramSocket.send(ack);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void reportError() {
        String errorCode = new String(bufferByteArray, 3, 1);
        String errorText = new String(bufferByteArray, 4,
                inBoundDatagramPacket.getLength() - 4);
        System.err.println("Error: " + errorCode + " " + errorText);
    }

    private void writeFile(ByteArrayOutputStream baoStream, String fileName) {
        try {
            OutputStream outputStream = new FileOutputStream(fileName);
            baoStream.writeTo(outputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


     // TFTP packet data size is maximum 512 bytes on last packet it will be less than 512 bytes

    private boolean isLastPacket(DatagramPacket datagramPacket) {
        if (datagramPacket.getLength() < 512)
            return true;
        else
            return false;
    }

    /*
     * RRQ / WRQ packet format
     *
     * 2 bytes - Opcode; string - filename; 1 byte - 0; string - mode; 1 byte -
     * 0;
     */
    private byte[] createRequest(final byte opCode, final String fileName,
                                 final String mode) {
        byte zeroByte = 0;
        int rrqByteLength = 2 + fileName.length() + 1 + mode.length() + 1;
        byte[] rrqByteArray = new byte[rrqByteLength];

        int position = 0;
        rrqByteArray[position] = zeroByte;
        position++;
        rrqByteArray[position] = opCode;
        position++;
        for (int i = 0; i < fileName.length(); i++) {
            rrqByteArray[position] = (byte) fileName.charAt(i);
            position++;
        }
        rrqByteArray[position] = zeroByte;
        position++;
        for (int i = 0; i < mode.length(); i++) {
            rrqByteArray[position] = (byte) mode.charAt(i);
            position++;
        }
        rrqByteArray[position] = zeroByte;
        return rrqByteArray;
    }
}