import java.io.File;
import java.util.Scanner;

public class Hello{
	
	public static void main(String[] args) {
		
		Scanner reader = new Scanner(System.in);
		
		System.out.println("Enter the parent directory (ex. C:\\Users\\User\\Desktop\\OOP):");
		String directory = reader.nextLine();
		
		if(!directory.isEmpty()) {
		
			System.out.println("Enter extension (ex. java/exe/c):");
			String extension = reader.next();
			if(!extension.isEmpty()) {
			
				File folder = null;
				
				try {
					folder = new File(directory);
					PrintOutFileNames(extension, folder);
				}
				catch(SecurityException securityEx) {
					System.out.println("Access to the directory denied");
				}
				catch(Exception ex) {
					System.out.println("An error has occured");
				}
				System.out.println("Program has ended.");
			    
			}else {
				System.out.println("An extension must be provided.");
			}
		}else {
			System.out.println("The directory path cannot be empty.");
		}
		
		reader.close();
	}
	
	private static String GetFileExtension(File file) {
		
		String fileName = file.getName();
	    return fileName.substring(fileName.lastIndexOf(".") + 1);
		
	}
	
	private static void PrintOutFileNames(String extension, File folder) {
		
		File[] listOfFiles = folder.listFiles();

		for(int i = 0; i < listOfFiles.length; i++)
			if(listOfFiles[i].isFile()) {
				if(extension.contains(".")) {
					if(listOfFiles[i].getName().equals(extension))
						System.out.println(listOfFiles[i].getName());
				}else {
					if(GetFileExtension(listOfFiles[i]).equals(extension))
						System.out.println(listOfFiles[i].getName());
				}	
			}else if(listOfFiles[i].isDirectory())
				PrintOutFileNames(extension,listOfFiles[i]);
		
	}
	
}