; Jonas Petraška PS Ik. Igr. IIprogr.
; Trečia užduotis, 1 variantas: apdoroti MOV, OUT, NOT, RCR, XLAT

.model small
.stack 100h

.data
	
	outputBuffer		db 		100 dup ( 30h ) ; išvedimo bufferis
	; file names and handles start
	outputFileHandle	dw		0
	inputFileHandle		dw		0
	inputFileName		db		100 dup ( 0h )
	outputFileName		db		100 dup ( 0h )
	; file names and handles end
	; mnemonikos, registrai, rm'ai, rcr start
	operations 			db 		"mov out not rcr xlat "
	registers 			db 		"alaxclcxdldxblbxahspchbpdhsibhdi"
	segmentRegisters 	db 		"escsssds"
	RMS 				db 		"[bx+si] [bx+di] [bp+si] [bp+di] [si]    [di]    [bp]    [bx]    "
	RMShift 			db 		"[bx+si+[bx+di+[bp+si+[bp+di+[si  + [di  + [bp  + [bx  + "
	RCRE 				db 		"1 cl"	; RCR 1 cl
	; mnemonikos, registrai, rm'ai, rcr end
	OPK 				db 		0	; operacijos kodas
	w 					db 		0	; komandos dydis ( 0 - 8bit, 1-16bit )
	d 					db 		0	; komandos kryptis ( 0 - rez. saugomas pirmam operande, 1 - rez.saugomas antram operande )
	temp 				db 		0
	mode 				db 		0	; mod
	register 			db 		0	; registras
	registerMemory 		db 		0	; registras/atmintis
	shift8 				db 		0	; 8bit poslinkis
	shift16 			dw 		0	; 16bit poslinkis
	; mnemonikos, registrai, rm'ai, rcr end
	loopCounter 		dw 		0	; naudosiu loopui
	ip 					dw 		100h	; instruction pointer ( program counter )
	; input bufferis start
	buffer 				db 		110h dup ( 0h )	; bufferis į kurį skaito failą
	bufferN 			dw 		0h				; poslinkis bufferyje ( kur dabar esame )
	; input bufferis end
	help 				db 		"Dalinio dissasemblerio naudojimas norint dissasemblinti .com failus:", 0dh, 0ah, "uzd_3.exe <output>.txt <input>.com; pvz: uzd_3.exe test.txt uzd.com", 0dh, 0ah, "/? - pagalba", 24h
	parameterLength		db		0
	newLine 			db 		0Dh, 0Ah
	space 				db 		' '
	colon 				db 		':', ' '
	comma 				db 		',', ' '
	letterH 			db 		'h'
	unsupportedT 		db 		"Neatpazinta", 0Dh, 0Ah
	
.code
	
	start:

		mov dx, @data				; perkeliam iš data į registrą ax
		mov ds, dx					; perkeliam iš ax į data segmentą

		;******************************************************************************************
		; Pagalbos pranešimas
		;******************************************************************************************
		
		xor cx, cx					; nunulinam cx, nes naudosim cl
		mov	cl, es:[ 80h ]			; programos paleidimo parametrų simbolių skaičius, kuris rašomas ES 80h baite
		
		cmp	cx, 0					; jei vartotojas nedavė jokių parametrų
		je Exit1					; nereikia nieko tikrinti, programą užbaigam
		
		mov	si, 82h					; programos paleidimo parametrai rašomi ES nuo 81h baito, įmetam į bazinį registrą, kad galėtumėm adresuoti
			
		FindHelp:					; ieškom pagalbos simbolio
		
			cmp	es:[ si ], '?/' ; lyginam pagalbos pranešimo simbolį su simboliu esančiu BX poslinkiu ES
			; atmintyje jaunesnysis baitas saugomas pirmiau,
			; todėl pirmasis baitas įrašomas į bl, antras į bh
			; dėl to /? virsta į ?/
			
			je SendHelp				; reikia spausdinti pagalbos pranešimą
			inc	si					; didinam poslinkį
			
		loop FindHelp				; jei dar nepatikrinom visų parametrų - tikrinam toliau
		jmp	NoHelp

		;******************************************************************************************
		; Spausdinam pagalbos pranešimą
		;******************************************************************************************
		
		SendHelp:
		
			mov	ah, 9			
			lea dx, help
			int	21h
			jmp EndProgram
			
		NoHelp:
		
			;******************************************************************************************
			; Nuskaitom parametrų eilutės ilgį, kuris saugomas 80h baite
			;******************************************************************************************
			
			mov cl, es:[ 80h ]
			dec cl				; sumažinam, nes reikia, kad prasidėtų nuo 0, o ne nuo 1
			mov parameterLength, cl
			
			cmp cl, 0h			; jei nėra parametrų, baigiam programą
			jz Exit1
			
			;******************************************************************************************
			; Skaitom input ir output failo pavadinimus
			;******************************************************************************************
		
			xor si, si
			xor di, di
			
			ReadOutput:	; nuskaitom output failo pavadinimą

				mov al, es:[ 82h + si ]
				cmp al, ' '
				je ReadInputStart
				mov [ outputFileName + di ], al
				
				xor cx, cx
				mov cl, parameterLength
				cmp si, cx
				je Exit1
				
				inc si
				inc di
				
			jmp ReadOutput
			
			ReadInputStart:
			
				inc si			; praleidžiam tarpą
				xor di, di
				
				ReadInput:	; nuskaito input failo pavadinimą
				
					xor cx, cx
					mov cl, parameterLength
					cmp si, cx
					je HandleOutputInputFile
				
					mov al, es:[ 82h + si ]
					mov [ inputFileName + di ], al
					
					inc si
					inc di
				
				jmp ReadInput
				
		; laikinas jumpas start		
		jmp NextStatement
		Exit1:
			jmp EndProgram
		NextStatement:
		; laikinas jumpas end
		
		;******************************************************************************************
		; Atidarom input ir output failus 
		;******************************************************************************************
		
		HandleOutputInputFile:
		
			; atidarom input failą
			mov ah, 3Dh
			lea dx, inputFileName
			xor cx, cx
			xor al, al
			int 21h
			jc Exit2
			mov inputFileHandle, ax ; pasiemam filehandle
			
			; sukuriam output failą
			mov ah, 3Ch
			lea dx, outputFileName
			xor cx, cx
			int 21h
			jc Exit2
			mov outputFileHandle, ax ; pasiemam filehandle	
			
		;******************************************************************************************
		; Nuskaitom kodo dalį
		;******************************************************************************************
		
		Reading:
		
			mov cx, 256d			; skaitom po 256 iš bufferio
			lea dx, buffer
			call ReadToBuffer
			
			mov bufferN, 0h
			mov loopCounter, cx
			cmp cx, 0h
			je Exit2
			
		;******************************************************************************************
		; Tikrinam ar bufferyje yra mums reikiamos komandos
		;******************************************************************************************
		
		;*********************************
		; si	|	komanda
		;---------------------------------	
		; 1			mov rg r/m
		; 2			mov s.reg r/m
		; 3			mov akum. atm.
		; 4			mov atm. akum
		; 5			mov reg bet.op.
		; 6			mov r/m bet.op.
		; 7			out akum. portas
		; 8			out akum. dx portas
		; 9			not r/m
		; 0Ah		rcr r/m {1;CL}
		; 0Bh		xlat
		; 0FFFFh	Neatpažinta
		;*********************************
		
		; laikinas jumpas start		
		jmp NextStatement1
		Exit2:
			jmp EndProgram
		NextStatement1:
		; laikinas jumpas end
		
		CheckOPK1:	
		
			mov si, bufferN
			mov al, [ buffer + si ]
			inc bufferN
			xor ah, ah
			call RecognizeOperation
	
			cmp si, 1h			; ar mov rg r/m
			jne ifStatement1
			call MOV1
			
			ifStatement1:
			cmp si, 2h			; ar mov s.reg r/m
			jne ifStatement2
			call MOV2
			
			ifStatement2:
			cmp si, 3h			; ar mov akum. atm.
			jne ifStatement3
			call MOV3
			
			ifStatement3:
			cmp si, 4h			; ar mov atm. akum
			jne ifStatement4
			call MOV4
			
			ifStatement4:
			cmp si, 5h			; ar mov reg bet.op.
			jne ifStatement5
			call MOV5
			
			ifStatement5:
			cmp si, 6h			; ar mov r/m bet.op.
			jne ifStatement6
			call MOV6
			
			ifStatement6:
			cmp si, 7h			; ar out akum. portas
			jne ifStatement7
			call OUT1
			
			ifStatement7:
			cmp si, 8h			; ar out akum. dx portas
			jne ifStatement8
			call OUT2
			
			ifStatement8:
			jmp ifStatement9
			
		CheckOPK2:
		
		jmp CheckOPK1
		
			ifStatement9:
				cmp si, 9h			; ar not r/m
				jne ifStatement10
				call NOT0
			
			ifStatement10:
				cmp si, 0Ah			; ar rcr r/m {1;CL}
				jne ifStatement11
				call RCR0
			
			ifStatement11:
				cmp si, 0Bh			; ar xlat
				jne ifStatement12
				call XLAT0
			
			ifStatement12:
				cmp si, 0FFFFh		; ar neatpažinta
				jne ifStatement13
				call Unsupported
			
			ifStatement13:
				inc ip
				mov cx, loopCounter
				dec loopCounter
			
		loop CheckOPK2
			
	jmp Reading	
	;******************************************************************************************
	; Užbaigiam programą ir uždarom input bei output failus
	;******************************************************************************************
	
	EndProgram:
		
		; uždarom input failą
		mov ah, 3Eh
		mov bx, inputFileHandle
		int 21h
		
		; uždarom output failą
		mov ah, 3Eh
		mov bx, outputFileHandle
		int 21h
		
		; užbaigiam programą
		mov ax, 4C00h
		int 21h
	
	;******************************************************************************************
	; Procedūros
	;******************************************************************************************

	; Skaito į bufferį, paduodam cx - kiek skaityt dx - bufferio offsetas, grąžina cx - kiek nuskaitė,
	proc ReadToBuffer
	
		push ax
		push bx
		
		xor al, al
		mov ah, 3Fh
		mov bx, inputFileHandle
		int 21h
		mov cx, ax		; kiek nuskaitė baitų
		
		pop bx
		pop ax
		ret
		
	endp ReadToBuffer
	
	; Iš bufferio į output failą įrašo bufferį, duodam dx - bufferio offsetas, cx - kiek įrašyti
	proc PrintOutOfBuffer
	
		push ax
		push bx
		
		mov bx, outputFileHandle
		mov ah, 40h
		xor al, al
		int 21h
		
		pop bx
		pop ax
		ret
		
	endp PrintOutOfBuffer
	
	; Į buffer įdeda naujus baitus, resetina bufferN ir loopCounter
	proc CleanRead
		
		push cx
		push dx
		push si
		
		mov si, bufferN
		cmp si, 256d	; jei vis dar nesusitvarkėm su prieš tai gauta informacija
		jne Leave1		; susitvarkom su ja, prieš imdami kitą
		
		mov cx, 256d
		lea dx, buffer
		call ReadToBuffer		; skaitom naują informaciją į bufferį
		
		mov bufferN, 0h
		mov loopCounter, cx
		inc loopCounter
		
		Leave1:
	
		pop si
		pop dx
		pop cx
		ret
		
	endp CleanRead
	
	; Apskaičiuoja ir atspausdina 16bit poslinkį; Paduodam ax  
	proc RegOut16
	
		push si
		push ax
		push cx
		push dx
		
		mov [ outputBuffer + 0 ], '0'
		mov [ outputBuffer + 1 ], '0'
		mov si, 1h
		
		Back1:
		
			mov cx, 10h
			xor dx, dx
			div cx
			add dx, '0'
			mov [ outputBuffer + si ], dl
			dec si
			cmp ax, 0h
			
		jne Back1
		
		xor si, si
		mov cx, 2h
		
		Loop1:
		
			cmp [ outputBuffer + si ], 39h
			jbe Next1
			
			add [ outputBuffer + si ], 7h
			
			Next1:
				inc si

		loop Loop1
		
		lea dx, outputBuffer
		mov cx, 2h
		call PrintOutOfBuffer
		
		pop dx
		pop cx
		pop ax
		pop si
		ret
		
	endp RegOut16
	
	; Apskaičiuoja ir atspausdina vietą kode ( instruction counter ); Paduodam ax;
	proc RegOutIP
	
		push si
		push ax
		push cx
		push dx
		
		mov [ outputBuffer + 0 ], '0'
		mov [ outputBuffer + 1 ], '0'
		mov [ outputBuffer + 2 ], '0'
		mov [ outputBuffer + 3 ], '0'
		mov si, 3h
		
		Back2:
		
			mov cx, 10h
			xor dx, dx
			div cx
			add dx, 30h
			mov [ outputBuffer + si ], dl
			dec si
			cmp ax, 0h
			
		jne Back2
		
		xor si, si
		mov cx, 4h
		
		Loop2:
		
			cmp [ outputBuffer + si ], 39h
			jbe Next2
			
			add [ outputBuffer + si ], 7h
			Next2:
				inc si
			
		loop Loop2
		
		lea dx, outputBuffer
		mov cx, 4h
		call PrintOutOfBuffer
		
		pop dx
		pop cx
		pop ax
		pop si
		ret
		
	endp RegOutIP
	
	; Išveda registro pavadinimą, į al paduodam reg ir w
	proc RegOut
		
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov cx, 4h
		xor ah, ah
		mul cl
		add al, w
		add al, w
		mov si, ax
		mov cx, 2h
		lea dx, [ registers + si ]
		call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp RegOut
	
	; Išveda segmentinio registro pavadinimą, į AL paduodam SR
	proc SRegOut

		push ax
		push bx
		push cx
		push dx
		push si
		
		mov cx, 2h
		xor ah, ah
		mul cl
		mov si, ax
		
		mov cx, 2h
		lea dx, [ segmentRegisters + si ]
		call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp SRegOut
	
	; Išvedam RM pavadinimą
	proc RMOut
		
		push ax
		push bx
		push cx
		push dx
		push si
		
		cmp registerMemory, 110b
		jne Next3
		
		mov cx, 1h
		lea dx, RMS
		call PrintOutOfBuffer
		
		mov ax, shift16
		call RegOutIP
		
		lea dx, letterH
		call PrintOutOfBuffer
		
		lea dx, [ RMS + 6 ]
		call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
		Next3:
		
			mov cx, 8h
			xor ah, ah
			mul cl
			mov si, ax
			mov cx, 8h
			lea dx, [ RMS + si]
			call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp RMOut
	
	; Išspausdina RM pavadinimą + 8bit poslinkis, paduodam RM į AL
	proc RMOutShift8

		push ax
		push bx
		push cx
		push dx
		push si
		
		mov cx, 7h
		xor ah, ah
		mul cl
		mov si, ax
		mov cx, 7h
		lea dx, [ RMShift + si ]
		call PrintOutOfBuffer
		
		xor ax, ax
		mov al, shift8
		call RegOut16
		
		lea dx, letterH
		mov cx, 1h
		call PrintOutOfBuffer
		
		lea dx, [ RMS + 6 ]
		mov cx, 1h
		call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp RMOutShift8
	
	; Išspausdina RM pavadinimą + 16bit poslinkis, paduodam RM į AL
	proc RMOutShift16
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov cx, 7h
		xor ah, ah
		mul cl
		mov si, ax
		mov cx, 7h
		lea dx, [ RMShift + si ]
		call PrintOutOfBuffer
		
		mov ax, shift16
		call RegOutIP
		
		lea dx, letterH
		mov cx, 1h
		call PrintOutOfBuffer
		
		lea dx, [ RMS + 6 ]
		mov cx, 1h
		call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp RMOutShift16
	
	; Randa mod, reg, RM; Paduodam OPK
	proc ModRegRM
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		call CleanRead
		mov si, bufferN
		mov al, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		mov temp, al
		xor ah, ah
		mov al, OPK
		mov cx, 10b
		div cl
		
		mov w, ah
		xor ah, ah
		div cl
		
		mov d, ah
		xor ah, ah
		mov al, temp
		mov cx, 1000b
		div cl
		
		mov registerMemory, ah
		xor ah, ah
		div cl
		
		mov register, ah
		mov mode, al
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp ModRegRM
	
	; Atpažįsta komandą, duodam AX - bufferį, grąžina SI - komandos numerį
	proc RecognizeOperation
	
		push bx
		push cx
		push dx
		
		mov si, 0FFFFh		; by default nustatom, kad komanda neatpažinta, jei atpažinsim pakeisim
		mov bx, ax			; išsisaugom ax registre bx, nes naudosim AND
		and al, 11110000b
		cmp al, 10110000b	; tikrinam ar mov reg bet.op
		jne ifStatement14
		mov si, 5
		
		ifStatement14:
			mov ax, bx
			and al, 11111100b
			cmp al, 10001000b	; tikrinam ar mov reg r/m 
			jne ifStatement15
			mov si, 1
		
		ifStatement15:
			mov ax, bx
			and al, 11111101b
			cmp al, 10001100b	; tikrinam ar mov s.reg r/m 
			jne ifStatement16
			mov si, 2
		
		ifStatement16:
			mov ax, bx
			and al, 11111110b
			cmp al, 10100000b	; tikrinam ar mov akum. atm.
			jne ifStatement17
			mov si, 3
		
		ifStatement17:
			mov ax, bx
			and al, 11111110b
			cmp al, 10100010b	; tikrinam ar mov atm. akum.
			jne ifStatement18
			mov si, 4
		
		ifStatement18:
			mov ax, bx
			and al, 11111110b
			cmp al, 11000110b	; tikrinam ar mov r/m bet.op
			jne ifStatement19
			mov si, 6
		
		ifStatement19:
			mov ax, bx
			and al, 11111110b
			cmp al, 11100110b	; tikrinam ar out akum. portas
			jne ifStatement20
			mov si, 7
		
		ifStatement20:
			mov ax, bx
			and al, 11111110b
			cmp al, 11101110b	; tikrinam ar out akum. dx portas
			jne ifStatement21
			mov si, 8
		
		ifStatement21:
			mov ax, bx
			and al, 11111110b
			cmp al, 11110110b	; tikrinam ar not r/m
			jne ifStatement22
			mov si, 9
		
		ifStatement22:
			mov ax, bx
			and al, 11111100b
			cmp al, 11010000b	; tikrinam ar rcr r/m {1;CL}
			jne ifStatement23
			mov si, 10d
		
		ifStatement23:
			mov ax, bx
			cmp al, 11010111b	; tikrinam ar xlat
			jne ifStatement24
			mov si, 11d
		
		ifStatement24:
			mov ax, bx		; grąžinam reikšmę į ax
		
		pop dx
		pop cx
		pop bx
		ret
		
	endp RecognizeOperation

	; Atskirų komandų atpažinimo, formulavimo ir spausdinimo procedūras
	; mov rg r/m
	proc MOV1
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov OPK, al
		call ModRegRM
		
		mov ax, ip
		dec ax
		call RegOutIP
		
		mov cx, 02h
		lea dx, colon
		call PrintOutOfBuffer
		
		xor ax, ax
		mov al, OPK
		call RegOut16
		
		mov al, temp
		call RegOut16
		
		; mod 11
		cmp mode, 011b
		jne Next4
		mov cx, 01h
		lea dx, space
		call PrintOutOfBuffer
		
		mov cx, 4h
		lea dx, operations
		call PrintOutOfBuffer
		
		cmp d, 0h
		jne Next5
		mov al, registerMemory
		call RegOut
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
		
		mov al, register
		call RegOut
		
		Next5:
		cmp d, 1h
		jne Next4
		mov al, register
		call RegOut
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
		
		mov al, registerMemory
		call RegOut
		
		Next4:
		
			; mod 00		
			cmp mode, 0b
			jne Next6
			cmp registerMemory, 110b
			jne Next7
			call CleanRead
		
			mov si, bufferN
			mov bl, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov al, bl
			call RegOut16
			call CleanRead
		
			mov si, bufferN
			mov bh, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov al, bh
			call RegOut16
		
			mov shift16, bx
		
		Next7:
		
			mov cx, 01h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, operations
			call PrintOutOfBuffer
		
		; tarpinis jump start
		jmp Next8
		Next6:
			jmp Next9
		Next8:
		; tarpinis jump end
		
			cmp d, 0h
			jne Next07
			mov al, registerMemory
			call RMOut
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
			
		mov al, register
		call RegOut
		
		Next07:
			cmp d, 1h
			jne Next9
			mov al, register
			call RegOut
				
			mov cx, 2h
			lea dx, comma
			call PrintOutOfBuffer
				
			mov al, registerMemory
			call RMOut
			
		Next9:
		
			; mod 01
			cmp mode, 01b
			jne Next10
			call CleanRead
			
			mov si, bufferN
			mov al, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov shift8, al
			call RegOut16
			
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, operations
			call PrintOutOfBuffer
			
			cmp d, 0h
			jne Next11
			mov al, registerMemory
			call RMOutShift8
			
			mov cx, 2h
			lea dx, comma
			call PrintOutOfBuffer
			
			mov al, register
			call RegOut
		
		Next11:
		
			cmp d, 1h
			jne Next10
			mov al, register
			call RegOut
			
			mov cx, 2h
			lea dx, comma
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RMOutShift8
			
		; mod 10
		Next10:
		
			cmp mode, 10b
			jne Next13
			call CleanRead
			
			mov si, bufferN
			mov al, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			call RegOut16
			call CleanRead
			
			mov si, bufferN
			mov ah, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov shift16, ax
			mov al, ah
			call RegOut16
			
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
		
		; tarpinis jump start
		jmp Next12
		Next13:
			jmp Next14
		Next12:
		; tarpinis jump end
		
		mov cx, 4h
		lea dx, operations
		call PrintOutOfBuffer
		
		cmp d, 0h
		jne Next15
		mov al, registerMemory
		call RMOutShift16
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
		
		mov al, register
		call RegOut
		
		Next15:
		
			cmp d, 1h
			jne Next14
			mov al, register
			call RegOut
			
			mov cx, 2h
			lea dx, comma
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RMOutShift16
			
		Next14:
		
			mov cx, 2h
			lea dx, newLine
			call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp MOV1

	; mov s.reg r/m
	proc MOV2
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov OPK, al
		call ModRegRM
		
		mov ax, ip
		dec ax
		call RegOutIP
		
		mov cx, 02h
		lea dx, colon
		call PrintOutOfBuffer
		
		xor ax, ax
		mov al, OPK
		call RegOut16
		
		mov al, temp
		call RegOut16
		
		mov w, 1h
		
		; mod 11
		cmp mode, 011b
		jne Next16
		
		mov cx, 01h
		lea dx, space
		call PrintOutOfBuffer
		
		mov cx, 4h
		lea dx, operations
		call PrintOutOfBuffer
		
		cmp d, 0h
		jne Next17
		mov al, registerMemory
		call RegOut
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
		
		mov al, register
		call SRegOut
		
		Next17:
		
			cmp d, 1h
			jne Next16
			mov al, register
			call SRegOut
			
			mov cx, 2h
			lea dx, comma
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RegOut
			
		; mod 00			
		Next16:
		
		cmp mode, 0b
		jne Next18
		cmp registerMemory, 110b
		jne Next19
		call CleanRead
		
		mov si, bufferN
		mov bl, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		mov al, bl
		call RegOut16
		call CleanRead
		
		mov si, bufferN
		mov bh, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		mov al, bh
		call RegOut16
		
		mov shift16, bx
		
		Next19:
		
			mov cx, 01h
			lea dx, space
			call PrintOutOfBuffer
			mov cx, 4h
			lea dx, operations
			call PrintOutOfBuffer
		
		; tarpinis jumpas start
		jmp Next20
		Next18:
			jmp Next21
		Next20:
		; tarpinis jumpas end
		
		cmp d, 0h
		jne Next22
		mov al, registerMemory
		call RMOut
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
		
		mov al, register
		call SRegOut
			
		Next22:
		
			cmp d, 1h
			jne Next18
			mov al, register
			call SRegOut
			
			mov cx, 2h
			lea dx, comma
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RMOut
		
		; mod 01			
		Next21:
	
		cmp mode, 01b
		jne Next24
		call CleanRead
		
		mov si, bufferN
		mov al, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		mov shift8, al
		call RegOut16
		
		mov cx, 1h
		lea dx, space
		call PrintOutOfBuffer
		
		mov cx, 4h
		lea dx, operations
		call PrintOutOfBuffer
		
		cmp d, 0h
		jne Next25
		mov al, registerMemory 
		call RMOutShift8
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
		
		mov al, register
		call SRegOut
		
		Next25:
		
			cmp d, 1h
			jne Next24
			mov al, register
			call SRegOut
			
			mov cx, 2h
			lea dx, comma
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RMOutShift8
		
		; mod 10
		Next24:
		
			cmp mode, 10b
			jne Next26
			call CleanRead
			
			mov si, bufferN
			mov al, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			call RegOut16
			call CleanRead
			
			mov si, bufferN
			mov ah, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov shift16, ax
			mov al, ah
			call RegOut16
			
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
		
		; tarpinis jumpas start
		jmp Next27
		Next26:
			jmp Next28
		Next27:
		; tarpinis jumpas end
		
		mov cx, 4h
		lea dx, operations
		call PrintOutOfBuffer
		
		cmp d, 0h
		jne Next29
		mov al, registerMemory
		call RMOutShift16
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
		
		mov al, register
		call SRegOut
		
		Next29:
		
			cmp d, 1h
			jne Next28
			mov al, register
			call SRegOut
			
			mov cx, 2h
			lea dx, comma
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RMOutShift16
		
		Next28:
		
			mov cx, 2h
			lea dx, newLine
			call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp MOV2	

	; mov akum. atm.
	proc MOV3
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov OPK, al
		mov ax, ip
		call RegOutIP
		
		mov cx, 02h
		lea dx, colon
		call PrintOutOfBuffer
		
		xor ax, ax
		mov al, OPK
		call RegOut16
		call CleanRead
		
		mov si, bufferN
		mov al, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		call RegOut16
		call CleanRead
		
		mov si, bufferN
		mov ah, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		mov shift16, ax
		mov al, ah
		call RegOut16
		
		mov cx, 1h
		lea dx, space
		call PrintOutOfBuffer
		
		mov cx, 4h
		lea dx, operations
		call PrintOutOfBuffer
		
		mov al, OPK
		mov ah, 0h
		mov cx, 10b
		div cl
		mov w, ah
		xor ax, ax
		add al, w
		add al, w
		mov si, ax
		lea dx, [ registers + si ]
		mov cx, 2h
		call PrintOutOfBuffer
		
		lea dx, comma
		call PrintOutOfBuffer
		
		mov cx, 1h
		lea dx, [ RMS ]
		call PrintOutOfBuffer
		
		mov ax, shift16
		call RegOutIP
		
		mov cx, 1h
		lea dx, letterH
		call PrintOutOfBuffer
		
		mov cx, 1h
		lea dx, [ RMS + 6 ]
		call PrintOutOfBuffer
		
		mov cx, 2h
		lea dx, newLine
		call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp MOV3

	; mov atm. akum
	proc MOV4
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov OPK, al
		mov ax, ip
		call RegOutIP
		
		mov cx, 02h
		lea dx, colon
		call PrintOutOfBuffer
		
		xor ax, ax
		mov al, OPK
		call RegOut16
		call CleanRead
		
		mov si, bufferN
		mov al, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		call RegOut16
		call CleanRead
		
		mov si, bufferN
		mov ah, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		mov shift16, ax
		mov al, ah
		call RegOut16
		
		mov cx, 1h
		lea dx, space
		call PrintOutOfBuffer
		
		mov cx, 4h
		lea dx, operations
		call PrintOutOfBuffer
		
		mov cx, 1h
		lea dx, [ RMS ]
		call PrintOutOfBuffer
		
		mov ax, shift16
		call RegOutIP
		
		mov cx, 1h
		lea dx, letterH
		call PrintOutOfBuffer
		
		mov cx, 1h
		lea dx, [ RMS+6 ]
		call PrintOutOfBuffer
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
		
		mov al, OPK
		mov ah, 0h
		mov cx, 10b
		div cl
		mov w, ah
		xor ax, ax
		add al, w
		add al, w
		mov si, ax
		lea dx, [ registers + si ]
		mov cx, 2h
		call PrintOutOfBuffer
		
		mov cx, 2h
		lea dx, newLine
		call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp MOV4

	; mov reg bet.op.
	proc MOV5
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov w, 0h
		mov bx, ax
		mov ax, ip
		call RegOutIP
		
		mov cx, 02h
		lea dx, colon
		call PrintOutOfBuffer
		
		mov ax, bx
		call RegOut16
		
		and ax, 00001000b
		cmp ax, 00001000b
		jne Next30
		mov w, 1h
		
		Next30:
		
			call CleanRead
			mov si, bufferN
			mov dl, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			xor dh, dh
			mov ax, dx
			call RegOut16
			
			cmp w, 1h
			jne Next31
			call CleanRead
			
			mov si, bufferN
			mov dh, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			xor ah, ah
			mov al, dh
			call RegOut16
		
		Next31:
		
			push dx
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, operations
			call PrintOutOfBuffer
			
			mov ax, bx
			xor dx, dx
			mov cx, 1000b
			div cx
			mov ax, dx
			mov cx, 4h
			mul cx
			add al, w
			add al, w
			mov si, ax
			lea dx, [ registers + si ]
			mov cx, 2h
			call PrintOutOfBuffer
			
			mov cx, 02h
			lea dx, comma
			call PrintOutOfBuffer
			
			pop dx
			xor ax, ax
			cmp w, 0h
			je Next32
			mov al, dh
			call RegOut16
		
		Next32:
		
			mov al, dl
			call RegOut16
			mov cx, 1h
			lea dx, letterH
			call PrintOutOfBuffer
			
			mov cx, 02h
			lea dx, newLine
			call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp MOV5

	; mov r/m bet.op.
	proc MOV6
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov OPK, al
		call ModRegRM
		
		mov ax, ip
		dec ax
		call RegOutIP
		
		mov cx, 02h
		lea dx, colon
		call PrintOutOfBuffer
		
		xor ax, ax
		mov al, OPK
		call RegOut16
		
		mov al, temp
		call RegOut16
		
		cmp mode, 00b
		jne Next33
		cmp registerMemory, 110b
		jne Next33
		call CleanRead
		
		mov si, bufferN
		mov al, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		call RegOut16
		call CleanRead
		
		mov si, bufferN
		mov ah, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		mov shift16, ax
		mov al, ah
		call RegOut16
		
		; mod 01
		Next33:
			cmp mode, 01b
			jne Next34
			call CleanRead
			
			mov si, bufferN
			mov al, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov shift8, al
			call RegOut16
		
		; mod 10		
		Next34:
			cmp mode, 10b
			jne Next35
			call CleanRead
			
			mov si, bufferN
			mov al, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			call RegOut16
			call CleanRead
			
			mov si, bufferN
			mov ah, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov shift16, ax
			mov al, ah
			call RegOut16
		
		Next35:
			call CleanRead
			mov si, bufferN
			mov bl, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov al, bl
			call RegOut16
			call CleanRead
			
			cmp w, 1h
			jne Next36
			mov si, bufferN
			mov bh, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov al, bh
			call RegOut16
			
		Next36:
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, operations
			call PrintOutOfBuffer
			
			mov al, registerMemory
			cmp mode, 00b
			jne Next37
			call RMOut
		
		Next37:
			cmp mode, 11b
			jne Next38
			call RegOut
		
		Next38:
			cmp mode, 01b
			jne Next39
			call RMOutShift8
		
		Next39:
			cmp mode, 10b
			jne Next40
			call RMOutShift16
		
		Next40:
			mov cx, 2h
			lea dx, comma
			call PrintOutOfBuffer
			
			mov ax, bx
			call RegOutIP
			
			mov cx, 1h
			lea dx, letterH
			call PrintOutOfBuffer
			
			mov cx, 2h
			lea dx, newLine
			call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp MOV6

	; out akum. portas
	proc OUT1
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov OPK, al
		mov ax, ip
		call RegOutIP
		
		mov cx, 02h
		lea dx, colon
		call PrintOutOfBuffer
		
		xor ax, ax
		mov al, OPK
		call RegOut16
		call CleanRead
		
		mov si, bufferN
		mov al, [ buffer + si ]
		inc bufferN
		inc ip
		dec loopCounter
		call RegOut16
		
		mov shift8, al
		mov cx, 1h
		lea dx, space
		call PrintOutOfBuffer
		
		mov cx, 4h
		lea dx, [ operations + 4 ]
		call PrintOutOfBuffer
		
		mov al, shift8
		call RegOut16
		
		mov cx, 1h
		lea dx, letterH
		call PrintOutOfBuffer
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
		
		mov al, OPK
		mov ah, 0h
		mov cx, 10b
		div cl
		mov w, ah
		xor ax, ax
		add al, w
		add al, w
		mov si, ax
		lea dx, [ registers + si ]
		mov cx, 2h
		call PrintOutOfBuffer
		
		mov cx, 2h
		lea dx, newLine
		call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp OUT1

	; out akum. dx portas
	proc OUT2
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov OPK, al
		mov ax, ip
		call RegOutIP
		
		mov cx, 02h
		lea dx, colon
		call PrintOutOfBuffer
		
		xor ax, ax
		mov al, OPK
		call RegOut16
		
		mov cx, 1h
		lea dx, space
		call PrintOutOfBuffer
		
		mov cx, 4h
		lea dx, [ operations + 4 ]
		call PrintOutOfBuffer
		
		mov cx, 2h
		lea dx, [ registers + 10 ]
		call PrintOutOfBuffer
		
		mov cx, 2h
		lea dx, comma
		call PrintOutOfBuffer
		
		mov al, OPK
		mov ah, 0h
		mov cx, 10b
		div cl
		mov w, ah
		xor ax, ax
		add al, w
		add al, w
		mov si, ax
		lea dx, [ registers + si ]
		mov cx, 2h
		call PrintOutOfBuffer
		
		mov cx, 2h
		lea dx, newLine
		call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp OUT2

	; not r/m
	proc NOT0
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov OPK, al
		call ModRegRM
		
		cmp register, 010b
		je Next41
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
		Next41:
		
			mov ax, ip
			dec ax
			call RegOutIP
			
			mov cx, 2h
			lea dx, colon
			call PrintOutOfBuffer
			
			mov al, OPK
			call RegOut16
			
			mov al, temp
			call RegOut16
			
			; mod 11
			cmp mode, 11b
			jne Next42
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, [ operations + 8 ]
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RegOut
		
		; mod 00
		Next42:
		
			cmp mode, 00b
			jne Next43
			cmp registerMemory, 110b
			jne Next44
			call CleanRead
			
			mov si, bufferN
			mov bl, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov al, bl
			call RegOut16
			call CleanRead
			
			mov si, bufferN
			mov bh, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov al, bh
			call RegOut16
			
			mov shift16, bx
		
		Next44:
		
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, [ operations + 8 ]
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RMOut
		
		; mod 01
		
		Next43:
		
			cmp mode, 01b
			jne Next45
			call CleanRead
			
			mov si, bufferN
			mov al, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov shift8, al
			call RegOut16
			
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, [ operations + 8 ]
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RMOutShift8
			
		; mod 10
		Next45:
		
			cmp mode, 10b
			jne Next46
			call CleanRead
			
			mov si, bufferN
			mov al, [buffer + si]
			inc bufferN
			inc ip
			dec loopCounter
			call RegOut16
			call CleanRead
			
			mov si, bufferN
			mov ah, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov shift16, ax
			mov al, ah
			call RegOut16
			
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, [ operations + 8 ]
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RMOutShift16
		
		Next46:
		
			mov cx, 2h
			lea dx, newLine
			call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp NOT0

	; rcr r/m {1;CL}
	proc RCR0
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov OPK, al
		call ModRegRM
		
		cmp register, 011b
		je Next47
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
		Next47:
			mov ax, ip
			dec ax
			call RegOutIP
			
			mov cx, 2h
			lea dx, colon
			call PrintOutOfBuffer
			
			mov al, OPK
			call RegOut16
			
			mov al, temp
			call RegOut16
			
			; mod 11
			cmp mode, 11b
			jne Next48
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			mov cx, 4h
			lea dx, [ operations + 12 ]
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RegOut
		
		; mod 00
		Next48:
			cmp mode, 00b
			jne Next49
			
			cmp registerMemory, 110b
			jne Next50
			call CleanRead
			
			mov si, bufferN
			mov bl, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov al, bl
			call RegOut16
			call CleanRead
			
			mov si, bufferN
			mov bh, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov al, bh
			call RegOut16
			
			mov shift16, bx
			
		Next50:
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, [ operations + 12 ]
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RMOut
		
		; mod 01
		Next49:
			cmp mode, 01b
			jne Next51
			call CleanRead
			
			mov si, bufferN
			mov al, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov shift8, al
			call RegOut16
			
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, [ operations + 12 ]
			call PrintOutOfBuffer
			mov al, registerMemory
			call RMOutShift8
		
		; mod 10
		Next51:
			cmp mode, 10b
			jne Next52
			call CleanRead
			
			mov si, bufferN
			mov al, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			call RegOut16
			call CleanRead
			
			mov si, bufferN
			mov ah, [ buffer + si ]
			inc bufferN
			inc ip
			dec loopCounter
			mov shift16, ax
			mov al, ah
			call RegOut16
			
			mov cx, 1h
			lea dx, space
			call PrintOutOfBuffer
			
			mov cx, 4h
			lea dx, [ operations + 12 ]
			call PrintOutOfBuffer
			
			mov al, registerMemory
			call RMOutShift16
		
		Next52:
			mov cx, 2h
			lea dx, comma
			call PrintOutOfBuffer
			
			xor ax, ax
			mov al, OPK
			mov cx, 10b
			div cl
			xor ah, ah
			div cl
			mov al, ah
			xor ah, ah
			mul cl
			mov si, ax
			lea dx, [ RCRE + si]
			call PrintOutOfBuffer
			mov cx, 2h
			lea dx, newLine
			call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp RCR0

	; xlat
	proc XLAT0
	
		push ax
		push bx
		push cx
		push dx
		push si
		
		mov OPK, al
		mov ax, ip
		call RegOutIP
		
		mov cx, 02h
		lea dx, colon
		call PrintOutOfBuffer
		
		xor ax, ax
		mov al, OPK
		call RegOut16
		
		mov cx, 1h
		lea dx, space
		call PrintOutOfBuffer
		
		mov cx, 4h
		lea dx, [ operations + 16 ]
		call PrintOutOfBuffer
		
		mov cx, 2h
		lea dx, newLine
		call PrintOutOfBuffer
		
		pop si
		pop dx
		pop cx
		pop bx
		pop ax
		ret
		
	endp XLAT0
	
	; Neatpažinta
	proc Unsupported
	
		push ax
		push cx
		push dx
		push ax
		
		mov ax, ip
		call RegOutIP
		
		mov cx, 2h
		lea dx, colon
		call PrintOutOfBuffer
		
		pop ax
		call RegOut16
		
		mov cx, 1h
		lea dx, space
		call PrintOutOfBuffer
		
		mov cx, 0Dh
		lea dx, UnsupportedT
		call PrintOutOfBuffer
		
		pop dx
		pop cx
		pop ax
		ret
		
	endp Unsupported
	
end start
