// Jonas Petraška PS 1gr, 2 pogr.

// Ketvirta užduotis, 10 variantas.

// Sudaryti dvipusį sąrašą. Parašyti procedūrą, kuri suspaudžia sąrašą, iš kelių iš eilės einančių vienodų elementų palikdama tik vieną.


#include <stdio.h>
#include <stdlib.h>

#define LENGTH 256

struct linkedListElement{

    struct linkedListElement *prev;
    int data;
    struct linkedListElement *next;

};

typedef struct linkedListElement Node;

//--------------------------------------Function headers-------------------------------------------------------------------------//

void CreateLinkedList( Node **Start, int *Created );
void AppendElement( Node **Start, int Element );
void InsertElement( Node *Prev, int Element );
void PushElement( Node **Start, int Element );
void DeleteElement( Node **Start, Node *Delete );
void CompressList( Node **Start, Node *Current );
void PrintList( Node *Start, FILE *Out );
void DeleteList( Node **Start );

//--------------------------------------------------------------------------------------------------------------------------------//

int main( ){

    FILE *In,
         *Out;

    char Input[ LENGTH ],
         Output[ LENGTH ];

    // Input, output and error checks

    printf( "Iveskite duomenu failo pavadinima : " );
    scanf( "%s", &Input );

    In = fopen( Input, "r" );

    if( In == NULL ){

        printf( "Nurodytas duomenu failas neegzistuoja. \n" );
        return -1;

    }

    printf( "Iveskite rezultatu failo pavadinima : " );
    scanf( "%s", &Output );

    Out = fopen( Output, "w" );

    if( Out == NULL ){

        printf( "Nurodytas duomenu failas neegzistuoja. \n" );
        return -1;

    }

    Node *Start;

    int Created = 0,
        Element;

    CreateLinkedList( &Start, &Created );

    while( fscanf( In, "%d", &Element ) != EOF )
        if( Element != '\n' && Element != ' ' )
            AppendElement( &Start, Element );

    CompressList( &Start, Start );

    PrintList( Start, Out );

    DeleteList( &Start );

    fclose( In );
    fclose( Out );

    return 0;

}

//--------------------------------------Function headers-------------------------------------------------------------------------//

void CreateLinkedList( Node **Start, int *Created ){

    if( *Created == 0 ){

        *Start = NULL;
        *Created = 1;

    }else printf( "Sarasas jau buvo sukurtas. \n" );

}

void AppendElement( Node **Start, int Element ){

    Node *new_item = ( Node* ) malloc( sizeof( Node ) );

    Node *last = *Start;

    new_item->data = Element;

    new_item->next = NULL;

    if( *Start == NULL ){

        new_item->prev = NULL;
        *Start = new_item;
        return;
    }

    while( last->next != NULL )
        last = last->next;

    last->next = new_item;

    new_item->prev = last;

}

void DeleteElement( Node **Start, Node *Delete ){

    if ( *Start == NULL || Delete == NULL )
        return;

    if ( *Start == Delete )
        *Start = Delete->next;

    if ( Delete->next != NULL )
        Delete->next->prev = Delete->prev;

    if ( Delete->prev != NULL )
        Delete->prev->next = Delete->next;

    free( Delete );

}

void CompressList( Node **Start, Node *Current ){

    if( Current->next == NULL )
        return;

    if( Current->data != Current->next->data )
        Current = Current->next;
    else
        DeleteElement( Start, Current->next );

    CompressList( Start, Current );

}

void PrintList( Node *Start, FILE *Out ){

    Node *last;

    if( Start != NULL ){

        fputs( "Dvikryptis sarasas judant i prieki : \n", Out );

        while( Start != NULL ){

            fprintf( Out, "%d ", Start->data );
            last = Start;
            Start = Start->next;

        }

        fputs( "\nDvikryptis sarasas judant atgal : \n", Out );

        while( last != NULL ){

            fprintf( Out, "%d ", last->data );
            last = last->prev;

        }

    }else printf( "Sarasas neegzistuoja !" );
}

void DeleteList( Node **Start ){

    Node *temp;

    while( *Start != NULL ){

        temp = *Start;
        *Start = ( *Start )->next;
        free( temp );

    }

}

void InsertElement( Node *Prev, int Element ){

    if( Prev == NULL ){

        printf( "Praeitas elementas neegzistuoja \n" );
        return;
    }

    Node *new_item = ( Node* ) malloc( sizeof( Node ) );

    new_item->data = Element;

    new_item->next = Prev->next;

    Prev->next = new_item;

    new_item->prev = Prev;

    if( new_item->next != NULL )
        new_item->next->prev = new_item;

}

void PushElement( Node **Start, int Element ){

    Node *new_item = ( Node* ) malloc( sizeof( Node ) );

    new_item->data = Element;

    new_item->next = (*Start);
    new_item->prev = NULL;

    if( ( *Start ) != NULL )
        ( *Start )->prev = new_item;

    ( *Start ) = new_item;

}

//--------------------------------------------------------------------------------------------------------------------------------//
