import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class POP3Client {
    private Socket socket;              // Socket'as prisijungimui prie POP3 serverio
    private BufferedReader reader;      // reader'is, kuris skaito serverio atsakymus
    private OutputStreamWriter writer;  // writer'is, kuris siuncia serveriui komandas

    // Prisijungiame prie POP3 serverio
    public void connect(String username, String password) throws IOException {
        socket = new Socket("pop3.mailosaur.net", 110);
        reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        writer = new OutputStreamWriter(socket.getOutputStream());
        String response = reader.readLine();
        if (!response.startsWith("+OK")) {
            throw new IOException("POP3 server connection error.");
        }
        sendCommand("USER " + username);
        sendCommand("PASS " + password);
    }

    // Sarašas visu zinuciu, kurios randasi mail'e
    public List<String> list() throws IOException {
        List<String> result = new ArrayList<>();
        sendCommand("LIST");
        String response = reader.readLine();
        if (!response.startsWith("+OK")) {
            throw new IOException("POP3 LIST command error.");
        }
        while ((response = reader.readLine()) != null) {
            if (response.equals(".")) {
                break;
            }
            result.add(response);
        }
        return result;
    }

    // Gauna zinute is mail'o
    public String retr(int msgNumber) throws IOException {
        sendCommand("RETR " + msgNumber);
        String response = reader.readLine();
        if (!response.startsWith("+OK")) {
            throw new IOException("POP3 RETR command error.");
        }
        StringBuilder message = new StringBuilder();
        while ((response = reader.readLine()) != null) {
            if (response.equals(".")) {
                break;
            }
            message.append(response).append("\n");
        }
        return message.toString();
    }

    // Atsijungiame nuo POP3 serverio
    public void disconnect() throws IOException {
        sendCommand("QUIT");
        socket.close();
    }

    // Issiunciame serveriui komanda
    private void sendCommand(String command) throws IOException {
        writer.write(command + "\r\n");
        writer.flush();
    }

    public static void main(String[] args) throws IOException {
        Console console = System.console();
        if (console == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        String username = console.readLine("Username: ");
        char[] password = console.readPassword("Password: ");
        POP3Client client = new POP3Client();
        try {
            client.connect(username, new String(password));
            List<String> messageList = client.list();
            System.out.println("Messages in mailbox:");
            for (String messageInfo : messageList) {
                System.out.println(messageInfo);
            }
            String message = client.retr(1);
            System.out.println("First message:\n" + message);
        } finally {
            client.disconnect();
        }
    }
}