.model small               ; Defines the memory model as small.
.stack 100h                ; Allocates 256 bytes for the stack.

.data                       ; Beginning of the data segment.
msg1 db "Iveskite teksta: $" ; Store the prompt string for input.
msg2 db 10,13,"ivestu raidziu skaicius: $" ; Store the output message, with newline and carriage return.
ten dw 10                   ; Store the constant value 10 for later number to string conversion.

.code                       ; Beginning of the code segment.
mov ax, @data               ; Load address of the data segment into AX.
mov ds, ax                  ; Move the data segment address into DS.

lea dx, msg1                ; Load effective address of msg1 into DX.
mov ah, 09h                 ; Function code for print string in DOS interrupt.
int 21h                     ; DOS interrupt: print string.

xor cx, cx                  ; Clear CX register (set it to zero).

readin:                     ; Label for reading in loop.
mov ah, 01h                 ; Function code for read character in DOS interrupt.
int 21h                     ; DOS interrupt: read character.
cmp al, 13                  ; Compare the input character with carriage return.
je endread                  ; If it's a carriage return, jump to endread.
cmp al, 'A'                 ; Compare the character with 'A'.
jb checkLower               ; If character < 'A', check if it's a lowercase.
cmp al, 'Z'                 ; Compare the character with 'Z'.
ja checkLower               ; If character > 'Z', check if it's lowercase.
inc cx                      ; If it's an uppercase letter, increment the counter.
jmp readin                  ; Jump back to read the next character.

checkLower:                 ; Label for checking lowercase letters.
cmp al, 'a'                 ; Compare character with 'a'.
jb readin                   ; If character < 'a', return to readin.
cmp al, 'z'                 ; Compare character with 'z'.
ja readin                   ; If character > 'z', return to readin.
inc cx                      ; If it's a lowercase letter, increment the counter.
jmp readin                  ; Jump back to read the next character.

endread:                    ; Label for end of reading.
lea dx, msg2                ; Load effective address of msg2 into DX.
mov ah, 09h                 ; Function code for print string in DOS interrupt.
int 21h                     ; DOS interrupt: print string.

mov ax, cx                  ; Move the count of letters from CX to AX.
xor cx, cx                  ; Clear CX register.

intout:                     ; Label for integer to ASCII conversion loop.
xor dx, dx                  ; Clear DX register.
div ten                     ; Divide AX by ten. Quotient in AX, remainder in DX.
add dl, 30h                 ; Convert remainder to ASCII.
push dx                     ; Push the ASCII character onto stack.
inc cx                      ; Increment count of digits.
cmp ax, 0                   ; Check if quotient is zero.
ja intout                   ; If not, repeat the conversion for next digit.

intwrite:                   ; Label for printing each digit.
pop dx                      ; Pop the top of the stack into DX.
mov ah, 02h                 ; Function code for print character in DOS interrupt.
int 21h                     ; DOS interrupt: print character.
loop intwrite               ; Loop to next iteration until CX becomes zero.

mov ax, 4C00h               ; Function code for exit program in DOS interrupt.
int 21h                     ; DOS interrupt: exit program.
end                         ; End of the program.

