#define _GNU_SOURCE
#include<stdio.h>
#include<stdlib.h>


/*pakeicia simboliu tvarka*/
void rearrangeWords(char *line, int lengthOfLine)
{
    char word_start = 0;
    int i;
    for (i = 0; i < lengthOfLine; i++)
    {
        if(line[i] == ' ' || line[i] == '\n' || line[i] == '\0')
        {
            int start = word_start;
            int end = i - 1;
            while (start < end)
            {
                char temp = line[start];
                line[start] = line[end];
                line[end] = temp;
                start++;
                end--;
            }
            word_start = i + 1;
        }
    }

}



int main(int argc, char *argv[])
{
    if(argc != 3)
    {
        fprintf(stderr, "Usage: %s input_file output_file", argv[0]);
    }

    FILE *inputFile = fopen(argv[1], "r");
    if(inputFile == NULL)
    {
        perror("Could not open input file");
        exit(EXIT_FAILURE);
    }

    FILE *outputFile = fopen(argv[2], "w");
    if(outputFile == NULL)
    {
        perror("Could not open output file");
        fclose(inputFile);
        exit(EXIT_FAILURE);

    }

    char *line = NULL;
    size_t buf_size = 0;
    ssize_t read = 0;
    while ( (read = getline(&line, &buf_size, inputFile)) != -1)/*&line reiskia adresa pirmo simbolio pozicijos, kur inputas bus idetas*/
    {
        int lengthOfLine = read;
        rearrangeWords(line, lengthOfLine);
        fputs(line, outputFile);
    }

    free(line);
    fclose(inputFile);
    fclose(outputFile);

    exit(EXIT_SUCCESS);
    return 0;
}


