unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, XPMan, ExtCtrls;

//Konstnt baz
const
  MaxBuff  = 8192;
  MaxTab   = 4095;
  No_Prev  = $7FFF;
  EOF_Char = -2;
  End_List = -1;
  Empty    = -3;
  MaxStack = 4096;
//

type
  //Tip baz
  AnyStr = String[255];
  String_Table_Entry = record
                       Used : boolean;
                       PrevChar : integer;
                       FollChar : integer;
                       Next     : integer;
  end;
  //
  TForm1 = class(TForm)
    XPManifest1: TXPManifest;
    od: TOpenDialog;
    sd: TSaveDialog;
    Label3: TLabel;
    Button3: TButton;
    Button4: TButton;
    od2: TOpenDialog;
    sd2: TSaveDialog;
    //Universalij procedr/funkcij apraai
    procedure Terminate;
    function Get_Hash_Code(PrevC, FollC : integer) : integer;
    procedure Make_Table_Entry(PrevC, FollC: integer);
    procedure Initialize_String_Table;
    function Initialize : integer;
    function Lookup_String(PrevC, FollC: integer) : integer;
    procedure Get_Char(var C: integer);
    procedure Put_Char(c : integer);
    //Ispaudimo procedr/funkcij apraai
    function Push(c : integer) : integer;
    procedure Pop(var c : integer);
    procedure Get_Code(var Hash_Code : integer);
    procedure Do_Decompression;
    //Suspaudimo procedr/funkcij apraai
    procedure Put_Code(Hash_Code : integer);
    procedure Do_Compression;
    //
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
   //Universali globali kinamj baz
   Input_File : file;
   Output_File : file;
   InBufSize : integer;
   Input_Buffer : array[1..MaxBuff] of byte;
   Output_Buffer : array[1..MaxBuff] of byte;
   Input_Pos : integer;
   Output_Pos : integer;
   String_Table : array[0..MaxTab] of String_Table_Entry;
   Table_Used : integer;
   Output_Code : integer;
   Input_Code : integer;
   fInputName, fOutputName : String;
   //Ispaudimo programos kintamj baz
   Stack : array[1..MaxStack] of integer;
   Stack_Pointer : integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//Universalij procedr/funkcij realizacija
procedure TForm1.Terminate;
begin
  if Output_Pos > 0 then
    try
      BlockWrite(Output_File, Output_Buffer, Output_Pos);
    except
      Application.MessageBox('Klaida! Paskutinis bait blokas nebuvo raytas  byl!',
                    'KLAIDA!', MB_OK + MB_ICONERROR + MB_DEFBUTTON1);
    end;
  try
    CloseFile(Input_File );
  except
    Application.MessageBox('Klaida! Duomen byla nebuvo skmingai udaryta!',
                    'KLAIDA!', MB_OK + MB_ICONERROR + MB_DEFBUTTON1);
  end;
  try
    CloseFile(Output_File);
  except
    Application.MessageBox('Klaida! Rezultat byla nebuvo skmingai udaryta!',
                    'KLAIDA!', MB_OK + MB_ICONERROR + MB_DEFBUTTON1);
  end;
end;

function TForm1.Get_Hash_Code(PrevC, FollC : integer) : integer;
var
  Index  : integer;
  Index2 : integer;
begin
  Index := ((PrevC SHL 5) XOR FollC) AND MaxTab;
  if not String_Table[Index].Used then
      Get_Hash_Code := Index
  else begin
    while String_Table[Index].Next <> End_List do
      Index := String_Table[Index].Next;
      Index2 := (Index + 101) AND MaxTab;
      while String_Table[Index2].Used do
        Index2 := succ(Index2) AND MaxTab;
        String_Table[Index].Next := Index2;
        Get_Hash_Code := Index2;
  end;
end;

procedure TForm1.Make_Table_Entry(PrevC, FollC: integer);
begin
  if Table_Used <= MaxTab then begin
    with String_Table[Get_Hash_Code(PrevC, FollC)] do begin
      Used := true;
      Next := End_List;
      PrevChar := PrevC;
      FollChar := FollC;
    end;
    INC( Table_Used );
  end;
end;

procedure TForm1.Initialize_String_Table;
var
  i: integer;
begin
  Table_Used := 0;
  for i := 0 to MaxTab do
    with String_Table[i] do begin
      PrevChar := No_Prev;
      FollChar := No_Prev;
      Next := -1;
      Used := false;
    end;
  for i := 0 to 255 do
    Make_Table_Entry(No_Prev, i);
end;

function TForm1.Initialize : integer;
begin
  AssignFile(Input_File, fInputName);
  try
    Reset(Input_File, 1);
  except
    Application.MessageBox('KRITIN KLAIDA! Nemanoma atverti failo skaitymui!',
                    'KLAIDA!', MB_OK + MB_ICONERROR + MB_DEFBUTTON1);
    Initialize := -1;
    exit;
  end;
  AssignFile(Output_File, fOutputName);
  try
    Rewrite(Output_File, 1);
  except
    Application.MessageBox('KRITIN KLAIDA! Nemanoma atverti failo raymui!',
                    'KLAIDA!', MB_OK + MB_ICONERROR + MB_DEFBUTTON1);
    Initialize := -1;
    exit;
  end;
  Input_Pos := MaxBuff + 1;
  Output_Pos := 0;
  InBufSize := 0;
  Output_Code := Empty;
  Input_Code := Empty;
  Initialize_String_Table;
  Initialize := 0;
end;

function TForm1.Lookup_String(PrevC, FollC: integer) : integer;
var
  Index : integer;
  Found : boolean;
begin
  Index := ((PrevC SHL 5) XOR FollC) AND MaxTab;
  Lookup_String := End_List;
  repeat
    Found := (String_Table[Index].PrevChar = PrevC) AND
             (String_Table[Index].FollChar = FollC);
    if (not Found) then
      Index := String_Table[Index].Next;
  until Found or (Index = End_List);
  if Found then
    Lookup_String := Index;
end;

procedure TForm1.Get_Char(var c: integer);
begin
  inc(Input_Pos);
  if (Input_Pos > InBufSize) then begin
    try
      BlockRead(Input_File, Input_Buffer, MaxBuff, InBufSize);
    except
    end;
    Input_Pos := 1;
  end;
  if(InBufSize = 0) then
    c := EOF_Char
  else
    c := Input_Buffer[Input_Pos];
end;

procedure TForm1.Put_Char(c : integer);
begin
  if (Output_Pos >= MaxBuff) then begin
    BlockWrite(Output_File, Output_Buffer, MaxBuff);
    Output_Pos := 0;
  end;
  inc(Output_Pos);
  Output_Buffer[Output_Pos] := c;
  //ShowMessage(inttostr(c));
end;


//Ispaudimo procedr/funkcij realizacija
function TForm1.Push(c : integer) : integer;
begin
  inc(Stack_Pointer);
  Stack[Stack_Pointer] := c;
  if (Stack_Pointer >= MaxStack) then begin
    Application.MessageBox('KRITIN KLAIDA! Steko perpildymas!',
                    'KLAIDA!', MB_OK + MB_ICONERROR + MB_DEFBUTTON1);
    Push := -1;
    Terminate;
    Exit;
  end;
  Push := 0;
end;

procedure TForm1.Pop(var c : integer);
begin
  if (Stack_Pointer > 0) then begin
    c := Stack[Stack_Pointer];
    dec(Stack_Pointer);
  end
  else
    c := Empty;
end;

procedure TForm1.Get_Code(var Hash_Code : integer);
var
  Local_Buf : integer;
begin
  if (Input_Code = Empty) then begin
    Get_Char(Local_Buf);
    if (Local_Buf = EOF_Char) then begin
      Hash_Code := EOF_Char;
      exit;
    end;
    Get_Char(Input_Code);
    if (Input_Code = EOF_Char) then begin
      Hash_Code := EOF_Char;
      exit;
    end;
    Hash_Code := ((Local_Buf SHL 4) AND $FF0) +    //Konstruojam local_Buf | Input_Code
                 ((Input_Code SHR 4) AND $00F);    //baita, pradzia LB pabaiga,
                                                   //pabaiga IC pradzia
    Input_Code := Input_Code AND $0F;              //Grazina IC antra pusbaiti
  end
  else begin
    Get_Char(Local_Buf);
    if (Local_Buf = EOF_Char) then begin
      Hash_Code := EOF_Char;
      exit;
    end;
    Hash_Code := Local_Buf + ((Input_Code SHL 8) AND $F00);
    Input_Code := Empty;
  end;
end;

procedure TForm1.Do_Decompression;
var
  C, Code, Old_Code, Fin_Char, In_Code, Last_Char, Temp_C : integer;
  Unknown : boolean;
begin
  Last_Char := 0;
  Stack_Pointer := 0;
  Unknown := false;
  Get_Code(Old_Code);
  Code := Old_Code;
  //showmessage(inttostr(code));
  c := String_Table[Code].FollChar;
  Put_Char(c);
  Fin_Char := c;
  Get_Code(In_Code);
  while (In_Code <> EOF_Char) do begin
    Code := In_Code;
    if (not String_Table[Code].Used) then begin
      Last_Char := Fin_Char;
      Code := Old_Code;
      Unknown := TRUE;
    end;
    while (String_Table[Code].PrevChar <> No_Prev) do
      WITH String_Table[Code] do begin
        Push(FollChar);
        Code := PrevChar;
      end;

    Fin_Char := String_Table[Code].FollChar;
    Put_Char( Fin_Char );
    Pop( Temp_C );
    while (Temp_C <> Empty) do begin
      Put_Char(Temp_C);
      Pop( Temp_C );
    end;
    if Unknown then begin
      Fin_Char := Last_Char;
      Put_Char(Fin_Char);
      Unknown  := false;
    end;
    Make_Table_Entry(Old_Code , Fin_Char);
    Old_Code := In_Code;
    Get_Code( In_Code );
  end;
end;


//Suspaudimo procedr/funkcij realizacija
procedure TForm1.Put_Code(Hash_Code : integer);
begin
  if (Output_Code = Empty) then begin
    Put_Char((Hash_Code SHR 4) AND $FF);
    Output_Code := Hash_Code AND $0F;
  end
  else begin
    Put_Char(((Output_Code SHL 4) AND $FF0) + ((Hash_Code SHR 8) AND $00F));
    Put_Char(Hash_Code AND $FF);
    Output_Code := Empty;
  end;
end;

procedure TForm1.Do_Compression;
var
  C  : integer;
  WC : integer;
  W  : integer;
begin
  Get_Char(C);
  W := Lookup_String(No_Prev, C);
  Get_Char(C);
  while (C <> EOF_Char) do begin
    WC := Lookup_String(W, C);
    if (WC = End_List) then begin
      Make_Table_Entry(W, C);
      Put_Code(W);
      W := Lookup_String(No_Prev, C);
    end
    else
      W := WC;        //paskutinio nario odyne indeksas
      Get_Char(C);
  end;
  Put_Code(W);
end;

//

procedure TForm1.Button3Click(Sender: TObject);
begin
  if od.Execute then begin
    fInputName := od.FileName;
    if sd.Execute then begin
      fOutputName := sd.FileName;
      if Initialize = -1 then
        Application.MessageBox('Rasta kritin klaida! Procesas sustabdomas!',
                        '!!!', MB_OK + MB_ICONWARNING + MB_DEFBUTTON1)
      else begin
        Do_Compression;
        Terminate;
        Application.MessageBox('Kompresavimas baigtas!',
                        'Pabaiga', MB_OK + MB_ICONINFORMATION + MB_DEFBUTTON1)
      end;
    end;
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  if od2.Execute then begin
    fInputName := od2.FileName;
    if sd2.Execute then begin
      fOutputName := sd2.FileName;
      if Initialize = -1 then
        Application.MessageBox('Rasta kritin klaida! Procesas sustabdomas!',
                        '!!!', MB_OK + MB_ICONWARNING + MB_DEFBUTTON1)
      else begin
        Do_Decompression;
        Terminate;
        Application.MessageBox('Dekompresavimas baigtas!',
                        'Pabaiga', MB_OK + MB_ICONINFORMATION + MB_DEFBUTTON1)
      end;
    end;
  end;
end;

end.
