
#include "BTree23.h"



void tNode::SetChild(int intWhichChild, tNode *pChild) {
	switch (intWhichChild) {
		case 0:
			pLeft = pChild;
			break;
		case 1:
			pMiddle = pChild;
			break;
		case 2:
			pRight = pChild;
			break;	
	}
	if (pChild != NULL) pChild->pParent = this;
}

tNode* tNode::GetBrother(int intWhichBrother) {
	if (pParent) {									//jei turi tv => jei turi broli
		if (pParent->pLeft == this) {				//is yra kairys
			if (intWhichBrother == 1) {
				return pParent->pMiddle;
			} else if (intWhichBrother == 2) {
				return pParent->pRight;
			} else {
				return NULL;
			}
		} else if (pParent->pMiddle == this) {		//is yra vidurinis
			if (intWhichBrother == -1) {
				return pParent->pLeft;
			} else if (intWhichBrother == 1) {
				return pParent->pRight;
			} else {
				return NULL;
			}
		} else {									//is yra deinys
			if (intWhichBrother == -2) {
				return pParent->pLeft;
			} else if (intWhichBrother == -1) {
				return pParent->pMiddle;
			} else {
				return NULL;
			}
		}
	} else {
		return NULL;
	}
}

void tNode::RemoveChild(int intWhichChild) {
	if (intWhichChild == 1) {
		pLeft = pMiddle; pMiddle = pRight; pRight = NULL;
	} else if (intWhichChild == 2) {
		pMiddle = pRight; pRight = NULL;
	} else if (intWhichChild == 3) {
		pRight = NULL;
	}
}


list<tItem> bTree23::GetListAsc() {
	return bTree23::GetListAsc(pRoot);							//be argumento - nuo virns
}

list<tItem> bTree23::GetListAsc(tNode *pNode) {
	list<tItem> lstTree, lstPart;
	
	lstTree.clear();
	if (pNode) {												//jei niekur nerodo, tai grinsim tui sra
		lstTree.merge(bTree23::GetListAsc(pNode->pLeft));		//visos reikms i kairio pomedio
		lstTree.push_back(pNode->SmallItem);					//tada pirma dalijanti reikm
		lstTree.merge(bTree23::GetListAsc(pNode->pMiddle));		//tada i vidurinio pomedio 
		if (pNode->LargeItem != NOVALUE) {
			lstTree.push_back(pNode->LargeItem);				//jei yra antra reikm, tai tada ji
			lstTree.merge(bTree23::GetListAsc(pNode->pRight));	//	ir deinys pomedis
		}
	}
	
	return lstTree;
}

list<tItem> bTree23::GetListDesc() {
	list<tItem> lstTemp;
	lstTemp = bTree23::GetListAsc();
	lstTemp.reverse();
	return lstTemp;						//paimam normal ir apveriam
}


void bTree23::Read(istream *pIStream, bool bPrintTree) {
	tItem i;
	while (!(*pIStream).eof()) {
		(*pIStream) >> i;
		if (!(*pIStream).fail()) {
			bTree23::Insert(i);
			if (bPrintTree) Print(&cout);
		} else {
			break;
		}
	}
}

void bTree23::Print(ostream *pOStream) {
	queue<tNode*> Q;
	tNode *pNode;
	int i = 0;
	
	Q.push(pRoot);
	Q.push(NULL);			//nauja eilut
	while (!Q.empty()) {
		pNode = Q.front();
		Q.pop();
		if (pNode) {
			(*pOStream) << '[' << pNode->SmallItem;
			if (pNode->LargeItem != NOVALUE) (*pOStream) << ", " << pNode->LargeItem;
			(*pOStream) << "]\t";
			if (pNode->pLeft) Q.push(pNode->pLeft);
			if (pNode->pMiddle) Q.push(pNode->pMiddle);
			if (pNode->pRight) Q.push(pNode->pRight);
			
			if (Q.front() == NULL) Q.push(NULL);			//jei paskutinis eilutj, pasakom, kad ir po jo vaik bus nauja eilut
		} else {											//NULL reikia, kad nauja eilut
			(*pOStream) << endl;
		}
	}
}

bool bTree23::Search(tItem Key) {
	tNode *pNode;
	bool bFound;
	
	pNode = bTree23::Search(pRoot, Key, &bFound);
	
	return bFound;
}

tNode* bTree23::Search(tNode *pNode, tItem Key, bool *pFound) {
	if (pNode != NULL) {
		if ((Key == pNode->SmallItem) || (Key == pNode->LargeItem)) {			//radom
			(*pFound) = true;
			return pNode;
		} else if (pNode->pLeft == NULL) {				//jau lapas, bet nedarom reikms
			(*pFound) = false;
			return pNode;
		} else if (Key < pNode->SmallItem) {	//kairj bus
			return bTree23::Search(pNode->pLeft, Key, pFound);
		} else if ((pNode->LargeItem != NOVALUE) && (Key > pNode->LargeItem)) {	//deinj bus
			return bTree23::Search(pNode->pRight, Key, pFound);
		} else {								//per vidur bus
			return bTree23::Search(pNode->pMiddle, Key, pFound);
		}
	} else {
		(*pFound) = false;
		return NULL;
	}
}

int bTree23::Insert(tItem Item){
	tNode *pLeaf;
	bool bFound;
	
	pLeaf = bTree23::Search(pRoot, Item, &bFound);
	if (bFound) return 1;
	
	if (pLeaf == NULL) {			//jei tuias medis
		pRoot = new tNode;
		pRoot->SmallItem = Item;
		
	} else if (pLeaf->LargeItem == NOVALUE) {		//jei tik 1 reikm
		
		if (pLeaf->SmallItem < Item) {
			pLeaf->LargeItem = Item;
		} else {
			pLeaf->LargeItem = pLeaf->SmallItem;
			pLeaf->SmallItem = Item;
		}
		
	} else {										//2 reikms, reiks dalinti
		bTree23::Split(pLeaf, Item);
	}
	
	return 0;
}

void bTree23::Split(tNode *pNode, tItem Item) {
	bTree23::Split(pNode, Item, NULL, NULL);
}

void bTree23::Split(tNode *pNode, tItem Item, tNode *pLeftChild, tNode *pRightChild) {
	tNode *pNewLeft, *pNewRight;
	int intSmall, intMiddle, intLarge;
	
	if (pNode->pParent == NULL) {		//kitaip sakant, jeigu akn dalijam
		pRoot = new tNode;
		pNode->pParent = pRoot;	
	}
	
	
	pNewLeft = new tNode;
	pNewRight = new tNode;
	
	if (pNode->SmallItem < Item) {
		if (pNode->LargeItem > Item) {			//per vidur
			intSmall = pNode->SmallItem;
			intMiddle = Item;
			intLarge = pNode->LargeItem;
			
			pNewLeft->SetChild(0, pNode->pLeft);
			pNewLeft->SetChild(1, pLeftChild);
			pNewRight->SetChild(0, pRightChild);
			pNewRight->SetChild(1, pNode->pRight);
		} else {								//deinj
			intSmall = pNode->SmallItem;
			intMiddle = pNode->LargeItem;
			intLarge = Item;
			
			pNewLeft->SetChild(0, pNode->pLeft);
			pNewLeft->SetChild(1, pNode->pMiddle);
			pNewRight->SetChild(0, pLeftChild);
			pNewRight->SetChild(1, pRightChild);
		}
	} else {									//kairj
		intSmall = Item;
		intMiddle = pNode->SmallItem;
		intLarge = pNode->LargeItem;
		
		pNewLeft->SetChild(0, pLeftChild);
		pNewLeft->SetChild(1, pRightChild);
		pNewRight->SetChild(0, pNode->pMiddle);
		pNewRight->SetChild(1, pNode->pRight);
	}
	pNewLeft->SmallItem = intSmall;
	pNewRight->SmallItem = intLarge;

	if (pNode->pParent->SmallItem == NOVALUE) {		//tyk k pridjom, nauja virn
		pNode->pParent->SmallItem = intMiddle;
		pNode->pParent->SetChild(0, pNewLeft);
		pNode->pParent->SetChild(1, pNewRight);
	} else if (pNode->pParent->LargeItem == NOVALUE) {		//dar yra kur dti
		if (pNode->pParent->pLeft == pNode) {				//jei tai kairysis vaikas
			pNode->pParent->LargeItem = pNode->pParent->SmallItem;
			pNode->pParent->SmallItem = intMiddle;
			
			pNode->pParent->pRight = pNode->pParent->pMiddle;
			pNode->pParent->SetChild(0, pNewLeft);
			pNode->pParent->SetChild(1, pNewRight);
		} else {											//vadinasi tai deinysis vaikas
			pNode->pParent->LargeItem = intMiddle;
			pNode->pParent->SetChild(1, pNewLeft);
			pNode->pParent->SetChild(2, pNewRight);
		}
	} else {										// tv nebetilps, tursim dalinti ir j
		bTree23::Split(pNode->pParent, intMiddle, pNewLeft, pNewRight);
	}
	
	delete pNode;
	
}

tNode* bTree23::FindNextItemNode(tNode *pNode, tItem Item){
	tNode *pCurrentNode;
	
	if (Item == pNode->SmallItem) {		//iekosim vidurine aka
		pCurrentNode = pNode->pMiddle;
	} else {							//iekosim deine aka
		pCurrentNode = pNode->pRight;
	}
	
	while (pCurrentNode->pLeft != NULL) {		//iekom kairiausio lapo
		pCurrentNode = pCurrentNode->pLeft;
	}
	
	return pCurrentNode;
}

int bTree23::Delete(tItem Item){
	tNode *pNode, *pLeafNode;
	bool bFound;
	
	pNode = bTree23::Search(pRoot, Item, &bFound);
	if (!bFound) return 1;
	
	if (pNode->pLeft != NULL) {		//jei ne lapas - sukeiiam, nes trinam nuo lapo
		pLeafNode = bTree23::FindNextItemNode(pNode, Item);		//surandam sekanio didesnio elemento virn (visada lapas)
		if (Item == pNode->SmallItem) {							//sukeiiam reikmes
			pNode->SmallItem = pLeafNode->SmallItem;
		} else {
			pNode->LargeItem = pLeafNode->SmallItem;
		}
		pLeafNode->SmallItem = Item;					//kad rastumm, kuri reikm imesti
	} else {
		pLeafNode = pNode;								//jau lapas - nustatom reikm
	}
	
	if (pLeafNode->LargeItem == Item) {					//jei anroji reikm
		pLeafNode->LargeItem = NOVALUE;					//tiesiog itrinam
	} else if (pLeafNode->LargeItem != NOVALUE) {		//jei pirmoji, bet yra 2 reikms
		pLeafNode->SmallItem = pLeafNode->LargeItem;	//itrinsim pirmj, antroji nuo iol bus pirmoji
		pLeafNode->LargeItem = NOVALUE;
	} else {											//buvo tik 1 reikm
		pLeafNode->SmallItem = NOVALUE;					//itrinam
		bTree23::Fix(pLeafNode);						//lapas be reikmi, taigi j "pataisom"
	}
	
	return 0;
}
void bTree23::Fix(tNode *pNode){
	tNode *pBrother, *pMyParent;
	
	if (pNode->pParent == NULL) {		//tuia aknis - nustatysim nauj
		pRoot = pNode->pLeft;			//nauja aknis
		delete pRoot->pParent;			//itrinam sen akn
		pRoot->pParent = NULL;			//nustatom, kad neturi tvo
	} else {
		pMyParent = pNode->pParent;
		if ((pBrother = pNode->GetBrother(+1)) && (pBrother->LargeItem != NOVALUE)) {		//jei bolis  dein turi 2 reikmes
			if (pMyParent->pLeft == pNode) {						//jei ia pats kairysis brolis - keisim su maja reikme
				pNode->SmallItem = pMyParent->SmallItem;
				pMyParent->SmallItem = pBrother->SmallItem;
			} else {													//vidurinis brolis - keisim su didesnija reikme
				pNode->SmallItem = pMyParent->LargeItem;
				pMyParent->LargeItem = pBrother->SmallItem;
			}
			pBrother->SmallItem = pBrother->LargeItem;					//i brolio maesnij reikm atmm
			pBrother->LargeItem = NOVALUE;
			
			pNode->pMiddle = pBrother->pLeft;							//pasiemam vaik
			pBrother->RemoveChild(1);									//deinys vetoj vidurinio, vidurinis vietoj kairo
		} else if ((pBrother = pNode->GetBrother(+2)) && (pBrother->LargeItem != NOVALUE)) {	//jei vidurinis turi 1 reikm, o deinys - 2
			pNode->SmallItem = pMyParent->SmallItem;				//pasiemam tvo ma reikm
			pBrother = pNode->GetBrother(+1);
			pMyParent->SmallItem = pBrother->SmallItem;			//tvui duodam i vidurinio brolio
			pBrother->SmallItem = NOVALUE;								//vidurinis lieka be reikmi
			
			pNode->pMiddle = pBrother->pLeft;							//pasiemam vaik
			pBrother->RemoveChild(1);									//deinys vetoj vidurinio, vidurinis vietoj kairo

			bTree23::Fix(pBrother);										//bet gals pasiimti i deinio brolio - sutvarkom
			
																		//tas pats  kit pus:
		} else if ((pBrother = pNode->GetBrother(-1)) && (pBrother->LargeItem != NOVALUE)) {		//jei bolis  kair turi 2 reikmes
			if (pMyParent->pRight == pNode) {						//jei ia pats deinysis brolis - keisim su didija reikme
				pNode->SmallItem = pMyParent->LargeItem;
				pMyParent->LargeItem = pBrother->LargeItem;
			} else {													//vidurinis brolis - keisim su maesnija reikme
				pNode->SmallItem = pMyParent->SmallItem;
				pMyParent->SmallItem = pBrother->LargeItem;
			}
			pBrother->LargeItem = NOVALUE;								//brolis didesnij reikm atidav ir nebeturi
			
			pNode->pMiddle = pNode->pLeft;
			pNode->pLeft = pBrother->pRight;
			pBrother->pRight = NULL;
			
		} else if ((pBrother = pNode->GetBrother(-2)) && (pBrother->LargeItem != NOVALUE)) {	//jei vidurinis turi 1 reikm, o kairys - 2
			pNode->SmallItem = pMyParent->LargeItem;				//pasiemam tvo didel reikm
			pBrother = pNode->GetBrother(-1);
			pMyParent->LargeItem = pBrother->SmallItem;				//tvui duodam i vidurinio brolio
			pBrother->SmallItem = NOVALUE;							//vidurinis lieka be reikmi
			
			pNode->pMiddle = pNode->pLeft;
			pNode->pLeft = pBrother->pRight;
			pBrother->pRight = NULL;
			
			bTree23::Fix(pBrother);									//bet gals pasiimti i kairiojo brolio - sutvarkom
			
																	//nebuvo brolio su 2 reikmm, reiks apjungti:
		} else if (pMyParent->LargeItem == NOVALUE) {				//jei tvas turi tik 1 reikm
			if (pMyParent->pLeft == pNode) {						//jei ia kairysis vaikas
				pBrother = pMyParent->pMiddle;						//brolis, kuriam duosim tvo reikm
				pBrother->LargeItem = pBrother->SmallItem;
				pBrother->SmallItem = pMyParent->SmallItem;			//terpiam  brolio maesnj tvo reikm
				pMyParent->SmallItem = NOVALUE;						//i tvo atmm
				
				pMyParent->pLeft = pBrother;						//perduodam brol kaip vienintel vaik
				pMyParent->pMiddle = NULL;
				
				pBrother->pRight = pBrother->pMiddle;				//pastumiam nuorodas, nes terpsim  pirmj viet
				pBrother->pMiddle = pBrother->pLeft;
				pBrother->pLeft = pNode->pLeft;						//terpiam
				pNode->pLeft = NULL;								//i virn vaiko nebeturi
				
				bTree23::Fix(pMyParent);							//tvas tuias - pataisom
				
				delete pNode;
			} else {												//ia deinysis (viduryje) vaikas
				pBrother = pMyParent->pLeft;						//brolis, kuriam duosim tvo reikm
				pBrother->LargeItem = pMyParent->SmallItem;
				pMyParent->SmallItem = NOVALUE;						//i tvo atmm
				pMyParent->pMiddle = NULL;							//io vaiko irgi nebeturi
				
				pBrother->pRight = pNode->pLeft;					//atiduodam broliui vaik
				pNode->pLeft = NULL;
				
				bTree23::Fix(pMyParent);							//tvas tuias - pataisom
				
				delete pNode;
			}
		} else {														//tvas turi 2 reikmes
			if (pMyParent->pLeft == pNode) {						//jei kairysis vaikas
				pBrother = pMyParent->pMiddle;
				
				pNode->SmallItem = pMyParent->SmallItem;
				pNode->LargeItem = pBrother->SmallItem;
				
				pMyParent->SmallItem = pMyParent->LargeItem;
				pMyParent->LargeItem = NOVALUE;
				
				pNode->pMiddle = pBrother->pLeft;					//pasiemam brolio vaikus
				pNode->pRight = pBrother->pMiddle;
				
				delete pMyParent->pMiddle;
				pMyParent->pMiddle = pMyParent->pRight;
				pMyParent->pRight = NULL;
				
			} else if (pMyParent->pMiddle == pNode) {				//jei vidurinis vaikas
				pBrother = pMyParent->pLeft;
				
				pBrother->LargeItem = pMyParent->SmallItem;			//atiduodam broliui tvo reikm
				pMyParent->SmallItem = pMyParent->LargeItem;
				pMyParent->LargeItem = NOVALUE;
				
				pBrother->pRight = pNode->pLeft;					//atiduodam broliui vaik
				
				delete pNode;
				pMyParent->pMiddle = pMyParent->pRight;
				pMyParent->pRight = NULL;
			} else if (pMyParent->pRight == pNode) {				//jei deinysis vaikas
				pBrother = pMyParent->pMiddle;
				
				pBrother->LargeItem = pMyParent->LargeItem;
				pMyParent->LargeItem = NOVALUE;
				
				pBrother->pRight = pNode->pLeft;					//atiduodam broliui vaik
				
				delete pNode;
				pMyParent->pRight = NULL;
			}
		}
	}
	
}
