//main.cpp
#include <iostream>
#include <fstream>
#include <vector>
#include <list>
#include "furniture.h"
#include "client.h"
#include "order.h"


using namespace std;

//duom-tipai
typedef vector<Furniture*> FurnitureVector;
typedef list<Client*> ClientList;
typedef list<Order*> OrderList;

//deklaracijos
//--bendros paskirties paprogrames
void saveAll(const string& fileName, 
              FurnitureVector& furnitures,
              ClientList& clients,
              OrderList& orders);
              
Client* SelectClient(ClientList& clients, string clientName);
Furniture* selectFurniture(FurnitureVector& furniture, string furnitureName);
              
void loadAll(const string& fileName, 
              FurnitureVector& furnitures,
              ClientList& clients,
              OrderList& orders);
void killAll (FurnitureVector& furnitures,
              ClientList& clients,
              OrderList& orders);
              
//------------Furniture---------------------
void printFurnitureList(FurnitureVector& furniture);
bool findedFurniture(FurnitureVector& furniture, string fname);
Furniture* selectFurniture(FurnitureVector& furniture);
void addFurniture(FurnitureVector& furniture);
//------------Client---------------------
void printClientList(ClientList& clients);
bool findedClient(ClientList& clients, string cname);
Client* SelectClient(ClientList& clients);
void addClient (ClientList& clients);
//-------------Order-------------------------
void booking (FurnitureVector& furniture, ClientList& clients, OrderList& orders);
void printOrdersList(OrderList& orders);
void printNotDoneTasks(OrderList& orders);
void printDoneTasks(OrderList& orders);
Order* SearchIndex(OrderList& orders, int z);
void perform_task(OrderList& orders);
void deleteOrder (OrderList& orders); 
//------------Info---------------------
void printFurnitureDetails(FurnitureVector& furniture);
void printClientDetails(ClientList& clients);

void clientInfo(ClientList& clients);
void furnitureInfo(FurnitureVector& furnitures);
void showBenefit (OrderList& orders);
void showProbBenefit (OrderList& orders);
void editOrdersData(OrderList& orders);

//-----------------------------------
int main ()
{
   const string FILE_NAME = "rez.txt";
    FurnitureVector furniture;//baldai
    ClientList clients;// klientai
    OrderList orders; //uzsakymai
    
   
    loadAll(FILE_NAME, furniture, clients, orders);
    for(;;)
    { 
        cout << endl
            << "Galimybes:"           << endl
            << endl
            << "  1 - Atspauzdinti baldu sarasa"    << endl
            << "  2 - Sukurti balda"    << endl
            <<endl
            << "  3 - Atspauzdinti klientu sarasa" << endl
            << "  4 - Sukurti klienta"    << endl
            <<endl
            << "  5 - Uzsakyti" << endl
            << "  6 - Atspauzdinti uzsakymu sarasa" << endl
            << "  7 - Atlikti Uzsakyma" << endl
            << "  8 - Neatlikti Uzsakymai"<<endl
            << "  9 - Atlikti Uzsakymai"<<endl
            <<endl
            << "  10 - Redaguoti uzsakyma"<<endl
            
            
            <<endl
            <<"Papildoma Informacija: "<<endl
            <<endl
            << "  11 - Klientu pelnas"<<endl
            << "  12 - Baldu pelnas"<<endl
            << "  13 - Kliento pelnas"<<endl
            << "  14 - Baldo pelnas"<<endl
            << "  15 - Realus laikotarpio pelnas"<<endl
            << "  16 - Prognozuojamas laikotarpio pelnas"<<endl
            <<endl
            << "  17 - Uzsakymo Pardavimas(sunaikinimas)"<<endl
            <<endl
            << "  0 - Iseiti"    << endl;
            cout <<"------>> ";
        string key;
        cin >> key;
        if (key == "0") break;
        else if (key == "1") printFurnitureList(furniture);
        else if (key == "2") addFurniture(furniture);
        else if (key == "3") printClientList(clients);
        else if (key == "4") addClient(clients);
        else if (key == "5") booking (furniture, clients, orders);
        else if (key == "6") printOrdersList(orders);
        else if (key == "7") perform_task(orders);
        else if (key == "8") printNotDoneTasks(orders); 
        else if (key == "9") printDoneTasks(orders);
        else if (key == "10") editOrdersData(orders);
        else if (key == "11") printFurnitureDetails(furniture);
        else if (key == "12") printClientDetails(clients);
        else if (key == "13") clientInfo(clients);
        else if (key == "14") furnitureInfo(furniture);
        else if (key == "15") showBenefit (orders);
        else if (key == "16") showProbBenefit (orders);
        else if (key == "17") deleteOrder(orders);

        else cout << endl << "Neteisinga komanda..." << endl;
    }  
    saveAll(FILE_NAME, furniture, clients, orders);
    killAll (furniture, clients, orders);
}


//----------------furniture---------------------------------------------------------------

void printFurnitureList(FurnitureVector& furniture)
{
    int z = 1;
    cout <<"---------------Baldu sarasas---------------"<<endl;
    for (int i=0; i < furniture.size(); i++)
    {
        cout <<z++<<". ";
        furniture[i]->print();
    }
    cout <<" Is viso baldu yra: "<<furniture.size()<<endl;
    cout <<"---------------Baldu saraso pabaiga---------------"<<endl;
} 


bool findedFurniture(FurnitureVector& furniture, string fname)
{
    bool a = false;
    for(int i=0 ;i< furniture.size();i++)
    {
        if (furniture[i]->getName() == fname) 
        {
            a = true;
            break;
        }   
    }
    return a;
}


Furniture* selectFurniture(FurnitureVector& furniture)
{
    if (furniture.empty())
        {
        cout << "baldu sarasas yra tuscias." << endl;
        return NULL;
    }
    
        for (;;)
    {
    
        string furnitureName;
        printFurnitureList(furniture);
    
        cout <<"Pasirinkite klienta ('#' - nutraukti):";
        cin >> furnitureName;
    
        if (furnitureName == "#")
            return NULL;
        
       
        for(int i=0 ;i< furniture.size();i++)
        {
           if (furniture[i]->getName() == furnitureName)  
            {
                return furniture[i];
            }
        }
    }
    return NULL;
}


void addFurniture(FurnitureVector& furniture)
{
    string name;
    for(;;)
    {
        printFurnitureList(furniture);
        cout << "<< ===================Naujas baldas================== >>" << endl;
        cout << "-->Naujo baldo pavadinimas ('#' - nutraukti): ";
        cin >> name;
        if (name == "#")
            return;
        if (findedFurniture(furniture, name) != true)
                break;	
                cout << "!! KLAIDA: toks baldas jau yra sarase !!" << endl;
    }
    double  price1, sellPrice1;
    cout << "Savikaina : ";
    cin >> price1;
    cout << "Pardavimo kaina: ";
    cin >> sellPrice1;
    furniture.push_back(new Furniture(name, price1, sellPrice1));       
}

//----------------client------------------------------------------------------------------------------  

void printClientList(ClientList& clients)
{
    int i=1;
    list<Client*>::iterator li = clients.begin();
    cout <<"---------------Klientu sarasas----------------------"<<endl;
    for (; li != clients.end(); li++)
    {
        cout <<i++<<". ";
        (*li)->print();
   }
    cout <<" Is viso klientu yra: "<<clients.size()<<endl;
    cout <<"---------------Clientu saraso pabaiga---------------"<<endl;
}  
 

bool findedClient(ClientList& clients, string cname)
{ bool a = false;

    list<Client*>::iterator li = clients.begin();
    for(;li != clients.end();li++)
    {
       if ((*li)->getName() == cname) 
        {
            a = true;
            break;
        }    
    }
    return a;   
}


void addClient (ClientList& clients)
{
    string name;
    for(;;)
    {
        printClientList(clients);
        cout <<endl;
        cout << "<< =====================S=Naujas klientas==================== >>" <<endl;
        cout << " Naujo kliento pavadinimas ('#' = nutraukti): ";
        cin >> name;
        if (name == "#")
            return;
        if (findedClient(clients, name) != true)
            break;
            
            cout << "!! KLAIDA: Toks klientas jau yra sarase !!" << endl;
    
    }
    clients.push_back(new Client(name));
}

Client* SelectClient(ClientList& clients)
{ 
    if (clients.empty())
    {
        cout << "Klientu sarasas yra tuscias." << endl;
        return NULL;
    }
        
    for (;;)
    {
        string clientName;
        printClientList(clients);
    
        cout <<"Pasirinkite klienta ('#' - nutraukti):";
        cin >> clientName;
    
        if (clientName == "#")
            return NULL;
            
        list<Client*>::iterator li = clients.begin();
        for(;li != clients.end();li++)
        {
            if ((*li)->getName() == clientName) 
            return (*li);
   
        }
    }
    return NULL;
}

//------------order--------------------------------------------------------------------------------

//...Uzsakymas..
void booking (FurnitureVector& furnitures, ClientList& clients, OrderList& orders)
{
    cout <<">>-- Baldu uzsakymas --<<" <<endl;
    Client* client = SelectClient(clients);
    if (client == NULL)
        return;
    Furniture* furniture = selectFurniture(furnitures);
    if (furniture == NULL)
        return;
    string bookingDate;
    int number; //baldu kiekis
    
    cout << "Uzsakymo data (yyyy.mm.dd): "; cin >> bookingDate;
    cout << "Vienetu skaicius: "; cin >> number;

    Order* order = new Order(client, furniture ,number, bookingDate, "-"); 
    furniture->addOrder(order);
    client->addOrder(order);
    orders.push_back(order);    

}

void printOrdersList(OrderList& orders)
{
    int i=1;
    list<Order*>::iterator li = orders.begin();
    cout <<"---------------Uzsakymu sarasas----------------------"<<endl;
    for (; li != orders.end(); li++)
    {
        cout <<i++<<". ";
        (*li)->print();
    }
    cout <<" Is viso yra uzsakymu: "<<orders.size()<<endl;
    cout <<"---------------Uzsakymu saraso pabaiga---------------"<<endl;
}


void printNotDoneTasks(OrderList& orders)
{
    int i = 0;
    cout <<"--------------Neatliktos uzduotys------------"<<endl;
    list<Order*>::iterator li = orders.begin();
    for(; li != orders.end(); li++)
    {
        if ((*li)->getDoneDate() == "-")
        {   i++;
            cout <<i<<". ";
            (*li)->print();
            
            
        }
    }
    cout <<"   Is viso: "<< i <<endl;
    cout <<"---------------------------------------------"<<endl;
}


void printDoneTasks(OrderList& orders)
{
    int i = 0;
    cout <<"--------------Atliktos uzduotys------------"<<endl;
    list<Order*>::iterator li = orders.begin();
    for(; li != orders.end(); li++)
    {
        if ((*li)->getDoneDate() != "-")
        {
            i++;
            cout <<i;
            (*li)->print();
        }
    }
    cout <<"   Is viso: "<< i <<endl;
    cout <<"---------------------------------------------"<<endl;
}

Order* SearchIndex(OrderList& orders, int z) 
{
    int i=1;
    if (orders.empty()) //jei usakymu nera
        return NULL;
    
    list<Order*>::iterator li = orders.begin();
    for(; i != z; li++)
    {
        
        if ( li == orders.end())
            return NULL;
            
        if ((*li)->getDoneDate() == "-")    
        i++;
    }
return (*li);
}

void perform_task(OrderList& orders)
{
    int z;
    cout <<">>-- Uzsakymo atlikimas --<<" <<endl;
    for(;;)
    {
        printNotDoneTasks(orders);
        cout << "Pasirinkite uzsakyma(0-nutraukti): "; cin >> z;
        if (z == 0)
            return;
            
        Order* order1 = SearchIndex(orders, z);
        if (order1 == NULL)
        {
            cout <<"Nera tokio uzsakymo"<<endl;
            return;
        }
        string date;
        cout << "Iveskite atlikimo data(yyyy.mm.dd): "; cin >> date;
        order1->setDoneDate(date);
        cout <<endl
        <<"------Uzsakymas atliktas--------"<<endl;
    }
}

//----------------------------------------------------
Order* SearchAllIndex(OrderList& orders, int z) 
{
    int i=1;
    if (orders.empty()) //jei usakymu nera
        return NULL;
    
    list<Order*>::iterator li = orders.begin();
    for(; i != z; li++)
    {
        
        if ( li == orders.end())
            return NULL;
  
        i++;
    }
return (*li);
}


void editOrdersData(OrderList& orders)
{
    printOrdersList(orders);
    int z = 0;
    cout << "Iveskite uzsakymo numeri: "; cin >> z;
    if (z == 0 ) 
        return; 
    Order* order = SearchAllIndex(orders, z);
    if (order == NULL) 
        cout <<"Toks uzsakymas nerastas!!!"<<endl;
    else 
    {
        cout<<"----Issirinktas uzsakymas:----"<<endl;
        order->print();
        string nbdate;
        string nddate;
        int n;
        
        cout <<"Iveskite nauja uzsakymo data('0' - nieko nekeisti): "<<endl
            << "Datos formatas: yyyy.mm.dd: ";cin >> nbdate;
        
        cout <<"Iveskite nauja atlikimo data('0' - nieko nekeisti): "<<endl
            <<"Datos formatas: yyyy.mm.dd: "; cin >> nddate;
         
        cout <<"Iveskite nauja baldu kieki('0' - nieko nekeisti): "<<endl
            <<"Kiekis= "; cin >> n;
          
        if (nbdate != "0")
            order->setBookingDate(nbdate);
        if (nddate != "0")
            order->setDoneDate(nddate);
        if (n != 0)
            order->setNumber(n);
        
    }
   cout <<endl<< "Naujas uzsakymas :";order->print();
}
//------------------------------------------------------------


void deleteOrder (OrderList& orders) 
{
    int z = 0;
    ofstream a_File ( "archyve.txt", ios::app );
    for(;;)
    {
        printOrdersList(orders);
        cout << "Iveskite numeri elemento, kuri norite parduoti('0'-nutraukti): "; cin >> z;
        if (z == 0)
            cout<<"Parduotu prekiu archyvas saugomas faile 'archyve.txt')"<<endl;
            break;
    
        Order* order = SearchAllIndex(orders,z);
        if (order != NULL) 
        {
           string sellDate;
           cout<<"iveskite pardavimo data(yyyy.mm.dd): "; cin >> sellDate;
           a_File <<"<"<< sellDate <<">"<<endl;
            
            Furniture* furniture1 = (Furniture*)order->getFurniture();
                furniture1->writeToFile(a_File);
                furniture1->destroyOrder(order);
                
            Client* client1 = (Client*)order->getClient();
                client1->writeToFile(a_File);
                client1->destroyOrder(order);
            list<Order*>::iterator li = orders.begin();
            while (li != orders.end())
            {
                if (order == (*li))
                cout <<">>>>"<<(*li)->getNumber()<<"a"<<endl;
                    break;
                li++;
                
            }
            (*li)->writeToFile(a_File);
            orders.erase(li);
            //delete order;
        }else cout <<"!!Tokio elemento nera!!"<<endl;
    }
    a_File.close();
}


//-----------------------info----------------------------------------------------------------------

void printFurnitureDetails(FurnitureVector& furniture)
{
    int z = 1;
    cout <<"---------------Baldu sarasas---------------"<<endl;
    for (int i=0; i < furniture.size(); i++)
    {
        cout <<z++<<". ";
        furniture[i]->printInfo();
    }
    cout <<" Is viso baldu yra: "<<furniture.size()<<endl;
    cout <<"---------------Baldu saraso pabaiga---------------"<<endl;
} 


void printClientDetails(ClientList& clients)
{
    int i=1;
    list<Client*>::iterator li = clients.begin();
    cout <<"---------------Clientu sarasas----------------------"<<endl;
    for (; li != clients.end(); li++)
    {
        cout <<i++<<". ";
        (*li)->printInfo();
   }
    cout <<" Is viso klientu yra: "<<clients.size()<<endl;
    cout <<"---------------Clientu saraso pabaiga---------------"<<endl;
}  


void clientInfo(ClientList& clients)
{
Client* client = SelectClient(clients);
(*client).printInfo();    
}

void furnitureInfo(FurnitureVector& furnitures)
{
Furniture* furniture = selectFurniture(furnitures);
(*furniture).printInfo();    
}

void showBenefit (OrderList& orders)
{
   string dateFrom;
   string dateTo;
   cout << "-- laikotarpio pelnas --" << endl;
   cout << "   nuo kada (yyyy.mm.dd) '0' - nuo pradzios: "; cin >> dateFrom;
   cout << "   iki kada (yyyy.mm.dd) '9' - iki pabaigos: "; cin >> dateTo;
   
   cout <<endl;
   cout <<"--------------------------------------------------------------"<<endl;
   double totalBenefit = 0;
   OrderList::iterator oi = orders.begin();
   for (;  oi != orders.end();  oi++)
      if (dateFrom <= (*oi)->getDoneDate()  &&
          dateTo   >= (*oi)->getDoneDate())
      {
         (*oi)->print();
         totalBenefit += (*oi)->getBenefit();
      }
   cout << "laikotarpio pelnas: " << totalBenefit << endl;
}


void showProbBenefit (OrderList& orders)
{
   string dateFrom;
   string dateTo;
   cout << "-- Prognozuoajamas laikotarpio pelnas --" << endl;
   cout << "   nuo kada (yyyy.mm.dd) '0' - nuo pradzios: "; cin >> dateFrom;
   cout << "   iki kada (yyyy.mm.dd) '9' - iki pabaigos: "; cin >> dateTo;
   
   cout <<endl;
   cout <<"--------------------------------------------------------------"<<endl;
   double totalBenefit = 0;
   OrderList::iterator oi = orders.begin();
   for (;  oi != orders.end();  oi++)
      if (dateFrom <= (*oi)->getBookingDate()  &&
          dateTo   >= (*oi)->getBookingDate())
      {
         (*oi)->print();
         totalBenefit += (*oi)->getBenefit();
      }
   cout << "Prognozuojamas laikotarpio pelnas: " << totalBenefit << endl;
}

//-------------bendros paskirties funkcijos------------------------------------------------------------

Client* SelectClient(ClientList& clients, string clientName)
{        
    list<Client*>::iterator li = clients.begin();
    for(;li != clients.end();li++)
    {
        if ((*li)->getName() == clientName) 
        return (*li);
    }
    return NULL;
}


Furniture* selectFurniture(FurnitureVector& furnitures, string furnitureName)
{ 
        
        for(int i=0 ;i< furnitures.size();i++)
        {
           if (furnitures[i]->getName() == furnitureName)  
            {
                return furnitures[i];
            }
        }
    return NULL;
}



void saveAll(const string& fileName, 
              FurnitureVector& furnitures,
              ClientList& clients,
              OrderList& orders)
{
    ofstream outFile (fileName.c_str()) ;//??????
    //outFile.open (fileName)//paruosiama rasymui y faila
    
    outFile << furnitures.size() << endl;
    for(int i=0; i < furnitures.size(); i++)
        furnitures[i]->writeToFile(outFile);
        
    outFile << clients.size() << endl;
    ClientList::iterator ci = clients.begin();
    for (; ci != clients.end(); ci++)
        (*ci)->writeToFile(outFile);
        
    outFile << orders.size() << endl;
    OrderList::iterator oi = orders.begin();
    for (; oi != orders.end(); oi++)
        (*oi)->writeToFile(outFile );
        
    outFile.close();
}

void loadAll(const string& fileName, 
              FurnitureVector& furnitures,
              ClientList& clients,
              OrderList& orders)
{
    ifstream inFile (fileName.c_str());
    
    int furnitureNumb = 0;
    inFile >> furnitureNumb;
    for (int i = 0; i < furnitureNumb; i++)
    {
        string name;
        double price, sellPrice;
        inFile >> name >> price >> sellPrice;
        
        Furniture* furniture1 = new Furniture(name, price, sellPrice);
        furnitures.push_back(furniture1);
    }
    
    int clientNumb = 0;
    inFile >> clientNumb;
    for (int i = 0; i < clientNumb; i++)
    {
        string name;
        inFile >> name;
        
        Client* client = new Client(name);
        clients.push_back(client);
    }
    
    int orderNumb;
    inFile >>orderNumb;
    for(int i = 0; i < orderNumb; i++)
    {
        string clientName;
        string furnitureName;
        string bDate;
        string dDate;
        int number;
        inFile >> clientName>>furnitureName>>number>>bDate>>dDate;
        Client* client = SelectClient(clients, clientName);
        Furniture* furniture = selectFurniture(furnitures, furnitureName);
        
        Order* order = new Order(client, furniture ,number, bDate, dDate); 
        furniture->addOrder(order);
        client->addOrder(order);
        orders.push_back(order);
    }
    
    inFile.close();
}


void killAll (FurnitureVector& furnitures,
              ClientList& clients,
              OrderList& orders)
{
   for (int x = 0 ; x <  furnitures.size();  x++)
      delete furnitures[x];
   furnitures.clear();   

   ClientList::iterator cl = clients.begin();
   for (;  cl != clients.end();  cl++)
      delete (*cl);
   clients.clear();   

   OrderList::iterator ol = orders.begin();
   for (;  ol != orders.end();  ol++)
      delete (*ol);
   orders.clear();   
}

