#include <iostream>
#include <string>
#include <vector>
#include "order.h"
#include "furniture.h"
#include "client.h"

using namespace std;

Order::Order(const Client* client1,
             const Furniture* furniture1,
             int number, std::string bookingDate, std::string doneDate)
{
   this->client1 = client1;
   this->furniture1 = furniture1;
   this->number = number;
   this->bookingDate = bookingDate;
   this->doneDate = doneDate;
}

void Order::print() const
{
   //cout <<"*************************************************************"<<endl;
    cout <<" "<<client1->getName()<<"  "<<furniture1->getName()<<"  "<<number<<" vnt."<<endl
        <<"  <Uzsakyta>: "<<bookingDate<<endl<<"  <Atlikta>: "<<doneDate <<endl;
    cout <<"--------------------------------------------------------------"<<endl;
}

double Order::getBenefit() const
{
 return number * (furniture1->getSellPrice() - furniture1->getPrice());
}

void Order::writeToFile (std::ofstream& outFile)
{
    outFile <<client1->getName()<<" "<<furniture1->getName()
    <<" "<<number<<" "<<bookingDate<<" "<<doneDate<<endl;
}


