import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import PaketasPaslaugoms.SiulomosPaslaugos;
public class Plovykla {	
	private float pelnas;
	private BufferedReader skaitymasIsKlaviaturos = new BufferedReader(new InputStreamReader(System.in));
	private static LinkedList paslauguSarasas = new LinkedList();
	private static LinkedList darbuotojuSarasas = new LinkedList();
	private static LinkedList klientuSarasas = new LinkedList();
	
	
	public static void pridetiPaslauga(SiulomosPaslaugos paslauga) {
		paslauguSarasas.add(paslauga);
	}
	public static void pridetiDarbuotoja(ServisoDarbuotojas darbuotojas) {
		darbuotojuSarasas.add(darbuotojas);
	}
	public static void pridetiKlienta(Klientas klientas) {
		klientuSarasas.add(klientas);
	}
	public float getPelnas(){
		return pelnas;
	}
		public boolean patikrintiUzimtumaVisu(Klientas tempKlientas){
		
		ListIterator iterator = klientuSarasas.listIterator();
		int i=0;
		while (iterator.hasNext()){
			tempKlientas = (Klientas)iterator.next();
			if (tempKlientas.arGalimaAptarnauti() == true)
				i++;
		}
		if (i < klientuSarasas.size())
			return false;
		else 
			return true;
	}
		public SiulomosPaslaugos pasirinktiIsSiulomuPaslaugu()throws IOException{
		String str;
		int nr=0;
		boolean dar = true;
		
		while (dar){
			String pirmas  = JOptionPane.showInputDialog("Pasirinkite paslauga:"); 
			try{
				nr = Integer.parseInt(pirmas);
				if ((nr < 1) || (nr > paslauguSarasas.size())){
					throw new NumberFormatException();
				}
				dar = false;
			}
			catch (NumberFormatException x){
				 JOptionPane.showMessageDialog  (null,
				 "Jus ivedete netinkama skaiciu",
				 "Klaida",
				  JOptionPane.PLAIN_MESSAGE);
			}
		}
		return (SiulomosPaslaugos)paslauguSarasas.get(nr-1);
	}
	public ServisoDarbuotojas pasirinktiIsSiulomuDarbuotoju()throws IOException{
		String str;
		int nr=0;
		boolean dar = true;
		
		while (dar){
			String antras  = JOptionPane.showInputDialog("Pasirinkite darbuotoja:");
			try{
				nr = Integer.parseInt(antras);
				if ((nr < 1) || (nr > darbuotojuSarasas.size())){
					throw new NumberFormatException();
				}
				dar = false;
			}
			catch (NumberFormatException x){
				 JOptionPane.showMessageDialog  (null,
				 "Jus ivedete netinkama skaiciu",
				 "Klaida",
				  JOptionPane.PLAIN_MESSAGE);
			}
		}
		return (ServisoDarbuotojas)darbuotojuSarasas.get(nr-1);
	}
	public Klientas pasirinktiKlienta()throws IOException{
		String str;
		int nr=0;
		boolean dar = true;
				
		while (dar){
			String trecias  = JOptionPane.showInputDialog("Pasirinkite klienta:"); 
			try{
				nr = Integer.parseInt(trecias);
				//System.out.println(nr);
				if ((nr < 1) || (nr > klientuSarasas.size())){
					throw new NumberFormatException();
				}
				dar = false;
			}
			catch (NumberFormatException x){
				 JOptionPane.showMessageDialog  (null,
				 "Jus ivedete netinkama skaiciu",
				 "Klaida",
				  JOptionPane.PLAIN_MESSAGE);
			}
			
		}
		
		return (Klientas)klientuSarasas.get(nr-1);
	}
	public void padidintiPelna(float kiek){
		pelnas = pelnas + kiek;
	}
	public static SiulomosPaslaugos nustatytiPaslauga(String vardas) {
		SiulomosPaslaugos paslauga;
		int j = 0;
		do{					
			paslauga = (SiulomosPaslaugos)paslauguSarasas.get(j++);					 
		}while(paslauga.gautiPavadinima() != vardas);		
		return paslauga;
	}
	
	public static ServisoDarbuotojas nustatytiDarbuotoja(String vardas) {
		ServisoDarbuotojas darbuotojas;
		int j = 0;
		do{					
			darbuotojas = (ServisoDarbuotojas)darbuotojuSarasas.get(j++);
		}while(darbuotojas.gautiVarda() != vardas);	
		return darbuotojas;
	}
	public static Klientas nustatytiKlienta(String vardas) {
		Klientas klientas;
		int j = 0;
		do{					
			klientas = (Klientas)klientuSarasas.get(j++);					 
		}while(klientas.gautiVarda() != vardas);		
		return klientas;
	}	
	public static int gautiPaslauguSarasoDydi() {
		return paslauguSarasas.size();				
	}
	public static int gautiDarbuotojuSarasoDydi() {
		return darbuotojuSarasas.size();				
	}
	public static int gautiKlientuSarasoDydi(){
		return klientuSarasas.size();				
	}
	public static String gautiDarbuotojoVarda(int numeris) {
		ServisoDarbuotojas darbuotojas;
		darbuotojas =(ServisoDarbuotojas)darbuotojuSarasas.get(numeris);
		return 	darbuotojas.gautiVarda();			
	}
	public static String gautiKlientoVarda(int numeris) {
		Klientas klientas;
		klientas =(Klientas)klientuSarasas.get(numeris);
		return 	klientas.gautiVarda();			
	}
	public static SiulomosPaslaugos gautiPaslauga(int i) {		
		return (SiulomosPaslaugos)paslauguSarasas.get(i);					
	}
	public static ServisoDarbuotojas gautiDarbuotoja(int i) {		
		return (ServisoDarbuotojas)darbuotojuSarasas.get(i);					
	}
	public static Klientas gautiKlienta(int i) {		
		return (Klientas)klientuSarasas.get(i);					
	}
}